<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: Place holder for the Accounting information details
 * @subpackage Structs
 */
class AccountingInfo extends AbstractStructBase
{
    /**
     * The AccountVendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AccountVendor
     */
    public $AccountVendor;
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Airline
     */
    public $Airline;
    /**
     * The BaseFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\BaseFare
     */
    public $BaseFare;
    /**
     * The ChargeCategory
     * Meta informations extracted from the WSDL
     * - documentation: Holds the charge category information
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCategory;
    /**
     * The DocumentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\DocumentInfo
     */
    public $DocumentInfo;
    /**
     * The FareApplication
     * Meta informations extracted from the WSDL
     * - documentation: Holds the Fare application information Example: ONE
     * - minOccurs: 0
     * @var string
     */
    public $FareApplication;
    /**
     * The PaymentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PaymentInfo
     */
    public $PaymentInfo;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PersonName
     */
    public $PersonName;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public $Taxes;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous free text-related information associated with the particular ticketing information if applicable Example: INCLUDES SERVICE CHARGE
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The TicketingInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TicketingInfo
     */
    public $TicketingInfo;
    /**
     * The LinkCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LinkCode;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for AccountingInfo
     * @uses AccountingInfo::setAccountVendor()
     * @uses AccountingInfo::setAirline()
     * @uses AccountingInfo::setBaseFare()
     * @uses AccountingInfo::setChargeCategory()
     * @uses AccountingInfo::setDocumentInfo()
     * @uses AccountingInfo::setFareApplication()
     * @uses AccountingInfo::setPaymentInfo()
     * @uses AccountingInfo::setPersonName()
     * @uses AccountingInfo::setTaxes()
     * @uses AccountingInfo::setText()
     * @uses AccountingInfo::setTicketingInfo()
     * @uses AccountingInfo::setLinkCode()
     * @uses AccountingInfo::setType()
     * @uses AccountingInfo::setId()
     * @param \Sabre\TravelItineraryRead\Structs\AccountVendor $accountVendor
     * @param \Sabre\TravelItineraryRead\Structs\Airline $airline
     * @param \Sabre\TravelItineraryRead\Structs\BaseFare $baseFare
     * @param string $chargeCategory
     * @param \Sabre\TravelItineraryRead\Structs\DocumentInfo $documentInfo
     * @param string $fareApplication
     * @param \Sabre\TravelItineraryRead\Structs\PaymentInfo $paymentInfo
     * @param \Sabre\TravelItineraryRead\Structs\PersonName $personName
     * @param \Sabre\TravelItineraryRead\Structs\Taxes $taxes
     * @param string $text
     * @param \Sabre\TravelItineraryRead\Structs\TicketingInfo $ticketingInfo
     * @param string $linkCode
     * @param string $type
     * @param string $id
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\AccountVendor $accountVendor = null, \Sabre\TravelItineraryRead\Structs\Airline $airline = null, \Sabre\TravelItineraryRead\Structs\BaseFare $baseFare = null, $chargeCategory = null, \Sabre\TravelItineraryRead\Structs\DocumentInfo $documentInfo = null, $fareApplication = null, \Sabre\TravelItineraryRead\Structs\PaymentInfo $paymentInfo = null, \Sabre\TravelItineraryRead\Structs\PersonName $personName = null, \Sabre\TravelItineraryRead\Structs\Taxes $taxes = null, $text = null, \Sabre\TravelItineraryRead\Structs\TicketingInfo $ticketingInfo = null, $linkCode = null, $type = null, $id = null)
    {
        $this
            ->setAccountVendor($accountVendor)
            ->setAirline($airline)
            ->setBaseFare($baseFare)
            ->setChargeCategory($chargeCategory)
            ->setDocumentInfo($documentInfo)
            ->setFareApplication($fareApplication)
            ->setPaymentInfo($paymentInfo)
            ->setPersonName($personName)
            ->setTaxes($taxes)
            ->setText($text)
            ->setTicketingInfo($ticketingInfo)
            ->setLinkCode($linkCode)
            ->setType($type)
            ->setId($id);
    }
    /**
     * Get AccountVendor value
     * @return \Sabre\TravelItineraryRead\Structs\AccountVendor|null
     */
    public function getAccountVendor()
    {
        return $this->AccountVendor;
    }
    /**
     * Set AccountVendor value
     * @param \Sabre\TravelItineraryRead\Structs\AccountVendor $accountVendor
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setAccountVendor(\Sabre\TravelItineraryRead\Structs\AccountVendor $accountVendor = null)
    {
        $this->AccountVendor = $accountVendor;
        return $this;
    }
    /**
     * Get Airline value
     * @return \Sabre\TravelItineraryRead\Structs\Airline|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \Sabre\TravelItineraryRead\Structs\Airline $airline
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setAirline(\Sabre\TravelItineraryRead\Structs\Airline $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return \Sabre\TravelItineraryRead\Structs\BaseFare|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \Sabre\TravelItineraryRead\Structs\BaseFare $baseFare
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setBaseFare(\Sabre\TravelItineraryRead\Structs\BaseFare $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get ChargeCategory value
     * @return string|null
     */
    public function getChargeCategory()
    {
        return $this->ChargeCategory;
    }
    /**
     * Set ChargeCategory value
     * @param string $chargeCategory
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setChargeCategory($chargeCategory = null)
    {
        $this->ChargeCategory = $chargeCategory;
        return $this;
    }
    /**
     * Get DocumentInfo value
     * @return \Sabre\TravelItineraryRead\Structs\DocumentInfo|null
     */
    public function getDocumentInfo()
    {
        return $this->DocumentInfo;
    }
    /**
     * Set DocumentInfo value
     * @param \Sabre\TravelItineraryRead\Structs\DocumentInfo $documentInfo
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setDocumentInfo(\Sabre\TravelItineraryRead\Structs\DocumentInfo $documentInfo = null)
    {
        $this->DocumentInfo = $documentInfo;
        return $this;
    }
    /**
     * Get FareApplication value
     * @return string|null
     */
    public function getFareApplication()
    {
        return $this->FareApplication;
    }
    /**
     * Set FareApplication value
     * @param string $fareApplication
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setFareApplication($fareApplication = null)
    {
        $this->FareApplication = $fareApplication;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \Sabre\TravelItineraryRead\Structs\PaymentInfo|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \Sabre\TravelItineraryRead\Structs\PaymentInfo $paymentInfo
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setPaymentInfo(\Sabre\TravelItineraryRead\Structs\PaymentInfo $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\TravelItineraryRead\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\TravelItineraryRead\Structs\PersonName $personName
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setPersonName(\Sabre\TravelItineraryRead\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\TravelItineraryRead\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\TravelItineraryRead\Structs\Taxes $taxes
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setTaxes(\Sabre\TravelItineraryRead\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \Sabre\TravelItineraryRead\Structs\TicketingInfo|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \Sabre\TravelItineraryRead\Structs\TicketingInfo $ticketingInfo
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setTicketingInfo(\Sabre\TravelItineraryRead\Structs\TicketingInfo $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get LinkCode value
     * @return string|null
     */
    public function getLinkCode()
    {
        return $this->LinkCode;
    }
    /**
     * Set LinkCode value
     * @param string $linkCode
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setLinkCode($linkCode = null)
    {
        $this->LinkCode = $linkCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
