<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UniqueID Structs
 * @subpackage Structs
 */
class UniqueID extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ID;
    /**
     * The SnapshotId
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $SnapshotId;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - documentation: Pnr creation date used for retrieve inactive pnr | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $CreateDate;
    /**
     * Constructor method for UniqueID
     * @uses UniqueID::setID()
     * @uses UniqueID::setSnapshotId()
     * @uses UniqueID::setCreateDate()
     * @param string $iD
     * @param string $snapshotId
     * @param string $createDate
     */
    public function __construct($iD = null, $snapshotId = null, $createDate = null)
    {
        $this
            ->setID($iD)
            ->setSnapshotId($snapshotId)
            ->setCreateDate($createDate);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Sabre\TravelItineraryRead\Structs\UniqueID
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get SnapshotId value
     * @return string|null
     */
    public function getSnapshotId()
    {
        return $this->SnapshotId;
    }
    /**
     * Set SnapshotId value
     * @param string $snapshotId
     * @return \Sabre\TravelItineraryRead\Structs\UniqueID
     */
    public function setSnapshotId($snapshotId = null)
    {
        $this->SnapshotId = $snapshotId;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \Sabre\TravelItineraryRead\Structs\UniqueID
     */
    public function setCreateDate($createDate = null)
    {
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\UniqueID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
