<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourType Structs
 * @subpackage Structs
 */
class TourType extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The MessageStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MessageStatus;
    /**
     * The TravelType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravelType;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CompanyType
     */
    public $Vendor;
    /**
     * The StartDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\LocationDetailsType
     */
    public $StartDetails;
    /**
     * The EndDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\LocationDetailsType
     */
    public $EndDetails;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Price
     */
    public $Price;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public $Customer;
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Passengers
     */
    public $Passengers;
    /**
     * The Services
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Services
     */
    public $Services;
    /**
     * Constructor method for TourType
     * @uses TourType::setStatusCode()
     * @uses TourType::setMessageStatus()
     * @uses TourType::setTravelType()
     * @uses TourType::setVendor()
     * @uses TourType::setStartDetails()
     * @uses TourType::setEndDetails()
     * @uses TourType::setPrice()
     * @uses TourType::setCustomer()
     * @uses TourType::setPassengers()
     * @uses TourType::setServices()
     * @param string $statusCode
     * @param string $messageStatus
     * @param string $travelType
     * @param \Sabre\TravelItineraryRead\Structs\CompanyType $vendor
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType $startDetails
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType $endDetails
     * @param \Sabre\TravelItineraryRead\Structs\Price $price
     * @param \Sabre\TravelItineraryRead\Structs\PassengerType $customer
     * @param \Sabre\TravelItineraryRead\Structs\Passengers $passengers
     * @param \Sabre\TravelItineraryRead\Structs\Services $services
     */
    public function __construct($statusCode = null, $messageStatus = null, $travelType = null, \Sabre\TravelItineraryRead\Structs\CompanyType $vendor = null, \Sabre\TravelItineraryRead\Structs\LocationDetailsType $startDetails = null, \Sabre\TravelItineraryRead\Structs\LocationDetailsType $endDetails = null, \Sabre\TravelItineraryRead\Structs\Price $price = null, \Sabre\TravelItineraryRead\Structs\PassengerType $customer = null, \Sabre\TravelItineraryRead\Structs\Passengers $passengers = null, \Sabre\TravelItineraryRead\Structs\Services $services = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setMessageStatus($messageStatus)
            ->setTravelType($travelType)
            ->setVendor($vendor)
            ->setStartDetails($startDetails)
            ->setEndDetails($endDetails)
            ->setPrice($price)
            ->setCustomer($customer)
            ->setPassengers($passengers)
            ->setServices($services);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get MessageStatus value
     * @return string|null
     */
    public function getMessageStatus()
    {
        return $this->MessageStatus;
    }
    /**
     * Set MessageStatus value
     * @param string $messageStatus
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setMessageStatus($messageStatus = null)
    {
        $this->MessageStatus = $messageStatus;
        return $this;
    }
    /**
     * Get TravelType value
     * @return string|null
     */
    public function getTravelType()
    {
        return $this->TravelType;
    }
    /**
     * Set TravelType value
     * @param string $travelType
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setTravelType($travelType = null)
    {
        $this->TravelType = $travelType;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\TravelItineraryRead\Structs\CompanyType|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\TravelItineraryRead\Structs\CompanyType $vendor
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setVendor(\Sabre\TravelItineraryRead\Structs\CompanyType $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get StartDetails value
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetailsType|null
     */
    public function getStartDetails()
    {
        return $this->StartDetails;
    }
    /**
     * Set StartDetails value
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType $startDetails
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setStartDetails(\Sabre\TravelItineraryRead\Structs\LocationDetailsType $startDetails = null)
    {
        $this->StartDetails = $startDetails;
        return $this;
    }
    /**
     * Get EndDetails value
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetailsType|null
     */
    public function getEndDetails()
    {
        return $this->EndDetails;
    }
    /**
     * Set EndDetails value
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType $endDetails
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setEndDetails(\Sabre\TravelItineraryRead\Structs\LocationDetailsType $endDetails = null)
    {
        $this->EndDetails = $endDetails;
        return $this;
    }
    /**
     * Get Price value
     * @return \Sabre\TravelItineraryRead\Structs\Price|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \Sabre\TravelItineraryRead\Structs\Price $price
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setPrice(\Sabre\TravelItineraryRead\Structs\Price $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Sabre\TravelItineraryRead\Structs\PassengerType $customer
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setCustomer(\Sabre\TravelItineraryRead\Structs\PassengerType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Passengers value
     * @return \Sabre\TravelItineraryRead\Structs\Passengers|null
     */
    public function getPassengers()
    {
        return $this->Passengers;
    }
    /**
     * Set Passengers value
     * @param \Sabre\TravelItineraryRead\Structs\Passengers $passengers
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setPassengers(\Sabre\TravelItineraryRead\Structs\Passengers $passengers = null)
    {
        $this->Passengers = $passengers;
        return $this;
    }
    /**
     * Get Services value
     * @return \Sabre\TravelItineraryRead\Structs\Services|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \Sabre\TravelItineraryRead\Structs\Services $services
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public function setServices(\Sabre\TravelItineraryRead\Structs\Services $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\TourType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
