<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceCoupon Structs
 * @subpackage Structs
 */
class ServiceCoupon extends AbstractStructBase
{
    /**
     * The ClassOfService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClassOfService;
    /**
     * The StartLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartLocation;
    /**
     * The StartDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndLocation;
    /**
     * The CurrentStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrentStatus;
    /**
     * The coupon
     * @var string
     */
    public $coupon;
    /**
     * Constructor method for ServiceCoupon
     * @uses ServiceCoupon::setClassOfService()
     * @uses ServiceCoupon::setStartLocation()
     * @uses ServiceCoupon::setStartDateTime()
     * @uses ServiceCoupon::setEndLocation()
     * @uses ServiceCoupon::setCurrentStatus()
     * @uses ServiceCoupon::setCoupon()
     * @param string $classOfService
     * @param string $startLocation
     * @param string $startDateTime
     * @param string $endLocation
     * @param string $currentStatus
     * @param string $coupon
     */
    public function __construct($classOfService = null, $startLocation = null, $startDateTime = null, $endLocation = null, $currentStatus = null, $coupon = null)
    {
        $this
            ->setClassOfService($classOfService)
            ->setStartLocation($startLocation)
            ->setStartDateTime($startDateTime)
            ->setEndLocation($endLocation)
            ->setCurrentStatus($currentStatus)
            ->setCoupon($coupon);
    }
    /**
     * Get ClassOfService value
     * @return string|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param string $classOfService
     * @return \Sabre\TravelItineraryRead\Structs\ServiceCoupon
     */
    public function setClassOfService($classOfService = null)
    {
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get StartLocation value
     * @return string|null
     */
    public function getStartLocation()
    {
        return $this->StartLocation;
    }
    /**
     * Set StartLocation value
     * @param string $startLocation
     * @return \Sabre\TravelItineraryRead\Structs\ServiceCoupon
     */
    public function setStartLocation($startLocation = null)
    {
        $this->StartLocation = $startLocation;
        return $this;
    }
    /**
     * Get StartDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \Sabre\TravelItineraryRead\Structs\ServiceCoupon
     */
    public function setStartDateTime($startDateTime = null)
    {
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get EndLocation value
     * @return string|null
     */
    public function getEndLocation()
    {
        return $this->EndLocation;
    }
    /**
     * Set EndLocation value
     * @param string $endLocation
     * @return \Sabre\TravelItineraryRead\Structs\ServiceCoupon
     */
    public function setEndLocation($endLocation = null)
    {
        $this->EndLocation = $endLocation;
        return $this;
    }
    /**
     * Get CurrentStatus value
     * @return string|null
     */
    public function getCurrentStatus()
    {
        return $this->CurrentStatus;
    }
    /**
     * Set CurrentStatus value
     * @param string $currentStatus
     * @return \Sabre\TravelItineraryRead\Structs\ServiceCoupon
     */
    public function setCurrentStatus($currentStatus = null)
    {
        $this->CurrentStatus = $currentStatus;
        return $this;
    }
    /**
     * Get coupon value
     * @return string|null
     */
    public function getCoupon()
    {
        return $this->coupon;
    }
    /**
     * Set coupon value
     * @param string $coupon
     * @return \Sabre\TravelItineraryRead\Structs\ServiceCoupon
     */
    public function setCoupon($coupon = null)
    {
        $this->coupon = $coupon;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\ServiceCoupon
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
