<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentAssociationTag Structs
 * @subpackage Structs
 */
class SegmentAssociationTag extends AbstractStructBase
{
    /**
     * The CarrierCode
     * @var AirlineCode
     */
    public $CarrierCode;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DepartureDate;
    /**
     * The BoardPoint
     * @var CityCode
     */
    public $BoardPoint;
    /**
     * The OffPoint
     * @var CityCode
     */
    public $OffPoint;
    /**
     * The ClassOfService
     * @var CommonString
     */
    public $ClassOfService;
    /**
     * The BookingStatus
     * @var CommonString
     */
    public $BookingStatus;
    /**
     * Constructor method for SegmentAssociationTag
     * @uses SegmentAssociationTag::setCarrierCode()
     * @uses SegmentAssociationTag::setFlightNumber()
     * @uses SegmentAssociationTag::setDepartureDate()
     * @uses SegmentAssociationTag::setBoardPoint()
     * @uses SegmentAssociationTag::setOffPoint()
     * @uses SegmentAssociationTag::setClassOfService()
     * @uses SegmentAssociationTag::setBookingStatus()
     * @param AirlineCode $carrierCode
     * @param string $flightNumber
     * @param string $departureDate
     * @param CityCode $boardPoint
     * @param CityCode $offPoint
     * @param CommonString $classOfService
     * @param CommonString $bookingStatus
     */
    public function __construct(AirlineCode $carrierCode = null, $flightNumber = null, $departureDate = null, CityCode $boardPoint = null, CityCode $offPoint = null, CommonString $classOfService = null, CommonString $bookingStatus = null)
    {
        $this
            ->setCarrierCode($carrierCode)
            ->setFlightNumber($flightNumber)
            ->setDepartureDate($departureDate)
            ->setBoardPoint($boardPoint)
            ->setOffPoint($offPoint)
            ->setClassOfService($classOfService)
            ->setBookingStatus($bookingStatus);
    }
    /**
     * Get CarrierCode value
     * @return AirlineCode|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param AirlineCode $carrierCode
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociationTag
     */
    public function setCarrierCode(AirlineCode $carrierCode = null)
    {
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociationTag
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociationTag
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get BoardPoint value
     * @return CityCode|null
     */
    public function getBoardPoint()
    {
        return $this->BoardPoint;
    }
    /**
     * Set BoardPoint value
     * @param CityCode $boardPoint
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociationTag
     */
    public function setBoardPoint(CityCode $boardPoint = null)
    {
        $this->BoardPoint = $boardPoint;
        return $this;
    }
    /**
     * Get OffPoint value
     * @return CityCode|null
     */
    public function getOffPoint()
    {
        return $this->OffPoint;
    }
    /**
     * Set OffPoint value
     * @param CityCode $offPoint
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociationTag
     */
    public function setOffPoint(CityCode $offPoint = null)
    {
        $this->OffPoint = $offPoint;
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return CommonString|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param CommonString $classOfService
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociationTag
     */
    public function setClassOfService(CommonString $classOfService = null)
    {
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get BookingStatus value
     * @return CommonString|null
     */
    public function getBookingStatus()
    {
        return $this->BookingStatus;
    }
    /**
     * Set BookingStatus value
     * @param CommonString $bookingStatus
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociationTag
     */
    public function setBookingStatus(CommonString $bookingStatus = null)
    {
        $this->BookingStatus = $bookingStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociationTag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
