<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnOptions Structs
 * @subpackage Structs
 */
class ReturnOptions extends AbstractStructBase
{
    /**
     * The UnmaskCreditCard
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $UnmaskCreditCard;
    /**
     * The ShowTicketStatus
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: "ShowTicketStatus" is for specifying whether user wants status for each ticket or not.
     * @var bool
     */
    public $ShowTicketStatus;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - documentation: "Language" is used to translate attributes (like Cabin name).
     * - use: optional
     * @var bool
     */
    public $Language;
    /**
     * Constructor method for ReturnOptions
     * @uses ReturnOptions::setUnmaskCreditCard()
     * @uses ReturnOptions::setShowTicketStatus()
     * @uses ReturnOptions::setLanguage()
     * @param bool $unmaskCreditCard
     * @param bool $showTicketStatus
     * @param bool $language
     */
    public function __construct($unmaskCreditCard = false, $showTicketStatus = false, $language = null)
    {
        $this
            ->setUnmaskCreditCard($unmaskCreditCard)
            ->setShowTicketStatus($showTicketStatus)
            ->setLanguage($language);
    }
    /**
     * Get UnmaskCreditCard value
     * @return bool|null
     */
    public function getUnmaskCreditCard()
    {
        return $this->UnmaskCreditCard;
    }
    /**
     * Set UnmaskCreditCard value
     * @param bool $unmaskCreditCard
     * @return \Sabre\TravelItineraryRead\Structs\ReturnOptions
     */
    public function setUnmaskCreditCard($unmaskCreditCard = false)
    {
        $this->UnmaskCreditCard = $unmaskCreditCard;
        return $this;
    }
    /**
     * Get ShowTicketStatus value
     * @return bool|null
     */
    public function getShowTicketStatus()
    {
        return $this->ShowTicketStatus;
    }
    /**
     * Set ShowTicketStatus value
     * @param bool $showTicketStatus
     * @return \Sabre\TravelItineraryRead\Structs\ReturnOptions
     */
    public function setShowTicketStatus($showTicketStatus = false)
    {
        $this->ShowTicketStatus = $showTicketStatus;
        return $this;
    }
    /**
     * Get Language value
     * @return bool|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param bool $language
     * @return \Sabre\TravelItineraryRead\Structs\ReturnOptions
     */
    public function setLanguage($language = null)
    {
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\ReturnOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
