<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recipient Structs
 * Meta informations extracted from the WSDL
 * - documentation: A person or institution that receives or is awarded with e.g. voucher, money, etc.
 * @subpackage Structs
 */
class Recipient extends AbstractStructBase
{
    /**
     * The Guest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Guest
     */
    public $Guest;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * Constructor method for Recipient
     * @uses Recipient::setGuest()
     * @uses Recipient::setName()
     * @param \Sabre\TravelItineraryRead\Structs\Guest $guest
     * @param string $name
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\Guest $guest = null, $name = null)
    {
        $this
            ->setGuest($guest)
            ->setName($name);
    }
    /**
     * Get Guest value
     * @return \Sabre\TravelItineraryRead\Structs\Guest|null
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * Set Guest value
     * @param \Sabre\TravelItineraryRead\Structs\Guest $guest
     * @return \Sabre\TravelItineraryRead\Structs\Recipient
     */
    public function setGuest(\Sabre\TravelItineraryRead\Structs\Guest $guest = null)
    {
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Sabre\TravelItineraryRead\Structs\Recipient
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Recipient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
