<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rates Structs
 * Meta informations extracted from the WSDL
 * - documentation: Cost of visa
 * @subpackage Structs
 */
class Rates extends AbstractStructBase
{
    /**
     * The FOP
     * Meta informations extracted from the WSDL
     * - documentation: Form of payments
     * - minOccurs: 0
     * @var string
     */
    public $FOP;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Amount to pay
     * @var float
     */
    public $amount;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - documentation: Currency
     * @var string
     */
    public $currency;
    /**
     * Constructor method for Rates
     * @uses Rates::setFOP()
     * @uses Rates::setAmount()
     * @uses Rates::setCurrency()
     * @param string $fOP
     * @param float $amount
     * @param string $currency
     */
    public function __construct($fOP = null, $amount = null, $currency = null)
    {
        $this
            ->setFOP($fOP)
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get FOP value
     * @return string|null
     */
    public function getFOP()
    {
        return $this->FOP;
    }
    /**
     * Set FOP value
     * @param string $fOP
     * @return \Sabre\TravelItineraryRead\Structs\Rates
     */
    public function setFOP($fOP = null)
    {
        $this->FOP = $fOP;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \Sabre\TravelItineraryRead\Structs\Rates
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \Sabre\TravelItineraryRead\Structs\Rates
     */
    public function setCurrency($currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Rates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
