<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QST Structs
 * @subpackage Structs
 */
class QST extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - documentation: "TaxCode" is used to return the tax code.
     * - use: optional
     * @var string
     */
    public $TaxCode;
    /**
     * Constructor method for QST
     * @uses QST::setAmount()
     * @uses QST::setCurrencyCode()
     * @uses QST::setPercent()
     * @uses QST::setTaxCode()
     * @param string $amount
     * @param string $currencyCode
     * @param string $percent
     * @param string $taxCode
     */
    public function __construct($amount = null, $currencyCode = null, $percent = null, $taxCode = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setPercent($percent)
            ->setTaxCode($taxCode);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\QST
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\QST
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\TravelItineraryRead\Structs\QST
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \Sabre\TravelItineraryRead\Structs\QST
     */
    public function setTaxCode($taxCode = null)
    {
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\QST
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
