<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessingTime Structs
 * Meta informations extracted from the WSDL
 * - documentation: Approximate time to process visa
 * @subpackage Structs
 */
class ProcessingTime extends AbstractStructBase
{
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - documentation: Duration of processing time
     * - minOccurs: 0
     * @var string
     */
    public $Duration;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Notes for processing time
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Unit
     * Meta informations extracted from the WSDL
     * - documentation: Processing time unit
     * - minOccurs: 0
     * @var string
     */
    public $Unit;
    /**
     * Constructor method for ProcessingTime
     * @uses ProcessingTime::setDuration()
     * @uses ProcessingTime::setNotes()
     * @uses ProcessingTime::setUnit()
     * @param string $duration
     * @param string $notes
     * @param string $unit
     */
    public function __construct($duration = null, $notes = null, $unit = null)
    {
        $this
            ->setDuration($duration)
            ->setNotes($notes)
            ->setUnit($unit);
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \Sabre\TravelItineraryRead\Structs\ProcessingTime
     */
    public function setDuration($duration = null)
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \Sabre\TravelItineraryRead\Structs\ProcessingTime
     */
    public function setNotes($notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param string $unit
     * @return \Sabre\TravelItineraryRead\Structs\ProcessingTime
     */
    public function setUnit($unit = null)
    {
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\ProcessingTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
