<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingElementsType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Common pricing elements
 * @subpackage Structs
 */
class PricingElementsType extends AbstractStructBase
{
    /**
     * The Deposit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Deposit
     */
    public $Deposit;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Discount[]
     */
    public $Discount;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Payment
     */
    public $Payment;
    /**
     * Constructor method for PricingElementsType
     * @uses PricingElementsType::setDeposit()
     * @uses PricingElementsType::setDiscount()
     * @uses PricingElementsType::setPayment()
     * @param \Sabre\TravelItineraryRead\Structs\Deposit $deposit
     * @param \Sabre\TravelItineraryRead\Structs\Discount[] $discount
     * @param \Sabre\TravelItineraryRead\Structs\Payment $payment
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\Deposit $deposit = null, array $discount = array(), \Sabre\TravelItineraryRead\Structs\Payment $payment = null)
    {
        $this
            ->setDeposit($deposit)
            ->setDiscount($discount)
            ->setPayment($payment);
    }
    /**
     * Get Deposit value
     * @return \Sabre\TravelItineraryRead\Structs\Deposit|null
     */
    public function getDeposit()
    {
        return $this->Deposit;
    }
    /**
     * Set Deposit value
     * @param \Sabre\TravelItineraryRead\Structs\Deposit $deposit
     * @return \Sabre\TravelItineraryRead\Structs\PricingElementsType
     */
    public function setDeposit(\Sabre\TravelItineraryRead\Structs\Deposit $deposit = null)
    {
        $this->Deposit = $deposit;
        return $this;
    }
    /**
     * Get Discount value
     * @return \Sabre\TravelItineraryRead\Structs\Discount[]|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Discount[] $discount
     * @return \Sabre\TravelItineraryRead\Structs\PricingElementsType
     */
    public function setDiscount(array $discount = array())
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Add item to Discount value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Discount $item
     * @return \Sabre\TravelItineraryRead\Structs\PricingElementsType
     */
    public function addToDiscount(\Sabre\TravelItineraryRead\Structs\Discount $item)
    {
        $this->Discount[] = $item;
        return $this;
    }
    /**
     * Get Payment value
     * @return \Sabre\TravelItineraryRead\Structs\Payment|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Sabre\TravelItineraryRead\Structs\Payment $payment
     * @return \Sabre\TravelItineraryRead\Structs\PricingElementsType
     */
    public function setPayment(\Sabre\TravelItineraryRead\Structs\Payment $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\PricingElementsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
