<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerType Structs
 * @subpackage Structs
 */
class PassengerType extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Type
     */
    public $Type;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PhoneType[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AddressType[]
     */
    public $Address;
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Age;
    /**
     * The DateOfBirth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DateOfBirth;
    /**
     * The Profile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Profile[]
     */
    public $Profile;
    /**
     * The passengerID
     * @var string
     */
    public $passengerID;
    /**
     * The primary
     * @var bool
     */
    public $primary;
    /**
     * Constructor method for PassengerType
     * @uses PassengerType::setType()
     * @uses PassengerType::setPersonName()
     * @uses PassengerType::setTelephone()
     * @uses PassengerType::setEmail()
     * @uses PassengerType::setAddress()
     * @uses PassengerType::setAge()
     * @uses PassengerType::setDateOfBirth()
     * @uses PassengerType::setProfile()
     * @uses PassengerType::setPassengerID()
     * @uses PassengerType::setPrimary()
     * @param \Sabre\TravelItineraryRead\Structs\Type $type
     * @param \Sabre\TravelItineraryRead\Structs\PersonNameType $personName
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType[] $telephone
     * @param string[] $email
     * @param \Sabre\TravelItineraryRead\Structs\AddressType[] $address
     * @param int $age
     * @param string $dateOfBirth
     * @param \Sabre\TravelItineraryRead\Structs\Profile[] $profile
     * @param string $passengerID
     * @param bool $primary
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\Type $type = null, \Sabre\TravelItineraryRead\Structs\PersonNameType $personName = null, array $telephone = array(), array $email = array(), array $address = array(), $age = null, $dateOfBirth = null, array $profile = array(), $passengerID = null, $primary = null)
    {
        $this
            ->setType($type)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setAge($age)
            ->setDateOfBirth($dateOfBirth)
            ->setProfile($profile)
            ->setPassengerID($passengerID)
            ->setPrimary($primary);
    }
    /**
     * Get Type value
     * @return \Sabre\TravelItineraryRead\Structs\Type|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Sabre\TravelItineraryRead\Structs\Type $type
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setType(\Sabre\TravelItineraryRead\Structs\Type $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\TravelItineraryRead\Structs\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\TravelItineraryRead\Structs\PersonNameType $personName
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setPersonName(\Sabre\TravelItineraryRead\Structs\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\TravelItineraryRead\Structs\PhoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType[] $telephone
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType $item
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function addToTelephone(\Sabre\TravelItineraryRead\Structs\PhoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return string[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param string[] $email
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function addToEmail($item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \Sabre\TravelItineraryRead\Structs\AddressType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AddressType[] $address
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setAddress(array $address = array())
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AddressType $item
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function addToAddress(\Sabre\TravelItineraryRead\Structs\AddressType $item)
    {
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setAge($age = null)
    {
        $this->Age = $age;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get Profile value
     * @return \Sabre\TravelItineraryRead\Structs\Profile[]|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * Set Profile value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Profile[] $profile
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setProfile(array $profile = array())
    {
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Add item to Profile value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Profile $item
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function addToProfile(\Sabre\TravelItineraryRead\Structs\Profile $item)
    {
        $this->Profile[] = $item;
        return $this;
    }
    /**
     * Get passengerID value
     * @return string|null
     */
    public function getPassengerID()
    {
        return $this->passengerID;
    }
    /**
     * Set passengerID value
     * @param string $passengerID
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setPassengerID($passengerID = null)
    {
        $this->passengerID = $passengerID;
        return $this;
    }
    /**
     * Get primary value
     * @return bool|null
     */
    public function getPrimary()
    {
        return $this->primary;
    }
    /**
     * Set primary value
     * @param bool $primary
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public function setPrimary($primary = null)
    {
        $this->primary = $primary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
