<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location Structs
 * Meta informations extracted from the WSDL
 * - documentation: Location information
 * @subpackage Structs
 */
class Location extends AbstractStructBase
{
    /**
     * The Regions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Regions
     */
    public $Regions;
    /**
     * The Resort
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Resort
     */
    public $Resort;
    /**
     * The cityCode
     * Meta informations extracted from the WSDL
     * - documentation: Location city code e.g. DFW
     * - use: optional
     * @var string
     */
    public $cityCode;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Location name if city code unavailable
     * - use: optional
     * @var string
     */
    public $name;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - documentation: "Origin" is used to return first city of particular Fare Component.
     * - use: optional
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - documentation: "Destination" is used to return last city of particular Fare Component.
     * - use: optional
     * @var string
     */
    public $Destination;
    /**
     * Constructor method for Location
     * @uses Location::setRegions()
     * @uses Location::setResort()
     * @uses Location::setCityCode()
     * @uses Location::setName()
     * @uses Location::setOrigin()
     * @uses Location::setDestination()
     * @param \Sabre\TravelItineraryRead\Structs\Regions $regions
     * @param \Sabre\TravelItineraryRead\Structs\Resort $resort
     * @param string $cityCode
     * @param string $name
     * @param string $origin
     * @param string $destination
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\Regions $regions = null, \Sabre\TravelItineraryRead\Structs\Resort $resort = null, $cityCode = null, $name = null, $origin = null, $destination = null)
    {
        $this
            ->setRegions($regions)
            ->setResort($resort)
            ->setCityCode($cityCode)
            ->setName($name)
            ->setOrigin($origin)
            ->setDestination($destination);
    }
    /**
     * Get Regions value
     * @return \Sabre\TravelItineraryRead\Structs\Regions|null
     */
    public function getRegions()
    {
        return $this->Regions;
    }
    /**
     * Set Regions value
     * @param \Sabre\TravelItineraryRead\Structs\Regions $regions
     * @return \Sabre\TravelItineraryRead\Structs\Location
     */
    public function setRegions(\Sabre\TravelItineraryRead\Structs\Regions $regions = null)
    {
        $this->Regions = $regions;
        return $this;
    }
    /**
     * Get Resort value
     * @return \Sabre\TravelItineraryRead\Structs\Resort|null
     */
    public function getResort()
    {
        return $this->Resort;
    }
    /**
     * Set Resort value
     * @param \Sabre\TravelItineraryRead\Structs\Resort $resort
     * @return \Sabre\TravelItineraryRead\Structs\Location
     */
    public function setResort(\Sabre\TravelItineraryRead\Structs\Resort $resort = null)
    {
        $this->Resort = $resort;
        return $this;
    }
    /**
     * Get cityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->cityCode;
    }
    /**
     * Set cityCode value
     * @param string $cityCode
     * @return \Sabre\TravelItineraryRead\Structs\Location
     */
    public function setCityCode($cityCode = null)
    {
        $this->cityCode = $cityCode;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Sabre\TravelItineraryRead\Structs\Location
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \Sabre\TravelItineraryRead\Structs\Location
     */
    public function setOrigin($origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \Sabre\TravelItineraryRead\Structs\Location
     */
    public function setDestination($destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Location
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
