<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item Structs
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The AirTaxi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AirTaxi
     */
    public $AirTaxi;
    /**
     * The Arunk
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Arunk
     */
    public $Arunk;
    /**
     * The Cruise
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public $Cruise;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The Hotel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public $Hotel;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Insurance
     */
    public $Insurance;
    /**
     * The MiscSegment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\MiscSegment
     */
    public $MiscSegment;
    /**
     * The Rail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Rail
     */
    public $Rail;
    /**
     * The Seats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Seats
     */
    public $Seats;
    /**
     * The Surface
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Surface
     */
    public $Surface;
    /**
     * The Tour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Tour
     */
    public $Tour;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Vehicle
     */
    public $Vehicle;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ProductType
     */
    public $Product;
    /**
     * The Ancillaries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Ancillaries
     */
    public $Ancillaries;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Item
     * @uses Item::setAirTaxi()
     * @uses Item::setArunk()
     * @uses Item::setCruise()
     * @uses Item::setFlightSegment()
     * @uses Item::setHotel()
     * @uses Item::setInsurance()
     * @uses Item::setMiscSegment()
     * @uses Item::setRail()
     * @uses Item::setSeats()
     * @uses Item::setSurface()
     * @uses Item::setTour()
     * @uses Item::setVehicle()
     * @uses Item::setProduct()
     * @uses Item::setAncillaries()
     * @uses Item::setRPH()
     * @uses Item::setId()
     * @param \Sabre\TravelItineraryRead\Structs\AirTaxi $airTaxi
     * @param \Sabre\TravelItineraryRead\Structs\Arunk $arunk
     * @param \Sabre\TravelItineraryRead\Structs\Cruise $cruise
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment[] $flightSegment
     * @param \Sabre\TravelItineraryRead\Structs\Hotel $hotel
     * @param \Sabre\TravelItineraryRead\Structs\Insurance $insurance
     * @param \Sabre\TravelItineraryRead\Structs\MiscSegment $miscSegment
     * @param \Sabre\TravelItineraryRead\Structs\Rail $rail
     * @param \Sabre\TravelItineraryRead\Structs\Seats $seats
     * @param \Sabre\TravelItineraryRead\Structs\Surface $surface
     * @param \Sabre\TravelItineraryRead\Structs\Tour $tour
     * @param \Sabre\TravelItineraryRead\Structs\Vehicle $vehicle
     * @param \Sabre\TravelItineraryRead\Structs\ProductType $product
     * @param \Sabre\TravelItineraryRead\Structs\Ancillaries $ancillaries
     * @param string $rPH
     * @param string $id
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\AirTaxi $airTaxi = null, \Sabre\TravelItineraryRead\Structs\Arunk $arunk = null, \Sabre\TravelItineraryRead\Structs\Cruise $cruise = null, array $flightSegment = array(), \Sabre\TravelItineraryRead\Structs\Hotel $hotel = null, \Sabre\TravelItineraryRead\Structs\Insurance $insurance = null, \Sabre\TravelItineraryRead\Structs\MiscSegment $miscSegment = null, \Sabre\TravelItineraryRead\Structs\Rail $rail = null, \Sabre\TravelItineraryRead\Structs\Seats $seats = null, \Sabre\TravelItineraryRead\Structs\Surface $surface = null, \Sabre\TravelItineraryRead\Structs\Tour $tour = null, \Sabre\TravelItineraryRead\Structs\Vehicle $vehicle = null, \Sabre\TravelItineraryRead\Structs\ProductType $product = null, \Sabre\TravelItineraryRead\Structs\Ancillaries $ancillaries = null, $rPH = null, $id = null)
    {
        $this
            ->setAirTaxi($airTaxi)
            ->setArunk($arunk)
            ->setCruise($cruise)
            ->setFlightSegment($flightSegment)
            ->setHotel($hotel)
            ->setInsurance($insurance)
            ->setMiscSegment($miscSegment)
            ->setRail($rail)
            ->setSeats($seats)
            ->setSurface($surface)
            ->setTour($tour)
            ->setVehicle($vehicle)
            ->setProduct($product)
            ->setAncillaries($ancillaries)
            ->setRPH($rPH)
            ->setId($id);
    }
    /**
     * Get AirTaxi value
     * @return \Sabre\TravelItineraryRead\Structs\AirTaxi|null
     */
    public function getAirTaxi()
    {
        return $this->AirTaxi;
    }
    /**
     * Set AirTaxi value
     * @param \Sabre\TravelItineraryRead\Structs\AirTaxi $airTaxi
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setAirTaxi(\Sabre\TravelItineraryRead\Structs\AirTaxi $airTaxi = null)
    {
        $this->AirTaxi = $airTaxi;
        return $this;
    }
    /**
     * Get Arunk value
     * @return \Sabre\TravelItineraryRead\Structs\Arunk|null
     */
    public function getArunk()
    {
        return $this->Arunk;
    }
    /**
     * Set Arunk value
     * @param \Sabre\TravelItineraryRead\Structs\Arunk $arunk
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setArunk(\Sabre\TravelItineraryRead\Structs\Arunk $arunk = null)
    {
        $this->Arunk = $arunk;
        return $this;
    }
    /**
     * Get Cruise value
     * @return \Sabre\TravelItineraryRead\Structs\Cruise|null
     */
    public function getCruise()
    {
        return $this->Cruise;
    }
    /**
     * Set Cruise value
     * @param \Sabre\TravelItineraryRead\Structs\Cruise $cruise
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setCruise(\Sabre\TravelItineraryRead\Structs\Cruise $cruise = null)
    {
        $this->Cruise = $cruise;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\TravelItineraryRead\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment $item
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function addToFlightSegment(\Sabre\TravelItineraryRead\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get Hotel value
     * @return \Sabre\TravelItineraryRead\Structs\Hotel|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * Set Hotel value
     * @param \Sabre\TravelItineraryRead\Structs\Hotel $hotel
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setHotel(\Sabre\TravelItineraryRead\Structs\Hotel $hotel = null)
    {
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \Sabre\TravelItineraryRead\Structs\Insurance|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param \Sabre\TravelItineraryRead\Structs\Insurance $insurance
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setInsurance(\Sabre\TravelItineraryRead\Structs\Insurance $insurance = null)
    {
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get MiscSegment value
     * @return \Sabre\TravelItineraryRead\Structs\MiscSegment|null
     */
    public function getMiscSegment()
    {
        return $this->MiscSegment;
    }
    /**
     * Set MiscSegment value
     * @param \Sabre\TravelItineraryRead\Structs\MiscSegment $miscSegment
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setMiscSegment(\Sabre\TravelItineraryRead\Structs\MiscSegment $miscSegment = null)
    {
        $this->MiscSegment = $miscSegment;
        return $this;
    }
    /**
     * Get Rail value
     * @return \Sabre\TravelItineraryRead\Structs\Rail|null
     */
    public function getRail()
    {
        return $this->Rail;
    }
    /**
     * Set Rail value
     * @param \Sabre\TravelItineraryRead\Structs\Rail $rail
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setRail(\Sabre\TravelItineraryRead\Structs\Rail $rail = null)
    {
        $this->Rail = $rail;
        return $this;
    }
    /**
     * Get Seats value
     * @return \Sabre\TravelItineraryRead\Structs\Seats|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param \Sabre\TravelItineraryRead\Structs\Seats $seats
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setSeats(\Sabre\TravelItineraryRead\Structs\Seats $seats = null)
    {
        $this->Seats = $seats;
        return $this;
    }
    /**
     * Get Surface value
     * @return \Sabre\TravelItineraryRead\Structs\Surface|null
     */
    public function getSurface()
    {
        return $this->Surface;
    }
    /**
     * Set Surface value
     * @param \Sabre\TravelItineraryRead\Structs\Surface $surface
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setSurface(\Sabre\TravelItineraryRead\Structs\Surface $surface = null)
    {
        $this->Surface = $surface;
        return $this;
    }
    /**
     * Get Tour value
     * @return \Sabre\TravelItineraryRead\Structs\Tour|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param \Sabre\TravelItineraryRead\Structs\Tour $tour
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setTour(\Sabre\TravelItineraryRead\Structs\Tour $tour = null)
    {
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \Sabre\TravelItineraryRead\Structs\Vehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \Sabre\TravelItineraryRead\Structs\Vehicle $vehicle
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setVehicle(\Sabre\TravelItineraryRead\Structs\Vehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Product value
     * @return \Sabre\TravelItineraryRead\Structs\ProductType|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \Sabre\TravelItineraryRead\Structs\ProductType $product
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setProduct(\Sabre\TravelItineraryRead\Structs\ProductType $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Ancillaries value
     * @return \Sabre\TravelItineraryRead\Structs\Ancillaries|null
     */
    public function getAncillaries()
    {
        return $this->Ancillaries;
    }
    /**
     * Set Ancillaries value
     * @param \Sabre\TravelItineraryRead\Structs\Ancillaries $ancillaries
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setAncillaries(\Sabre\TravelItineraryRead\Structs\Ancillaries $ancillaries = null)
    {
        $this->Ancillaries = $ancillaries;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
