<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel Structs
 * @subpackage Structs
 */
class Hotel extends AbstractStructBase
{
    /**
     * The BasicPropertyInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\BasicPropertyInfo
     */
    public $BasicPropertyInfo;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Customer
     */
    public $Customer;
    /**
     * The Guarantee
     * Meta informations extracted from the WSDL
     * - documentation: "Guarantee" is used to return guarantee-related information.
     * - minOccurs: 0
     * @var string
     */
    public $Guarantee;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\POS
     */
    public $POS;
    /**
     * The RoomRates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\RoomRates
     */
    public $RoomRates;
    /**
     * The SpecialPrefs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SpecialPrefs
     */
    public $SpecialPrefs;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous hotel-related information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The TimeSpan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TimeSpan
     */
    public $TimeSpan;
    /**
     * The DayOfWeekInd
     * Meta informations extracted from the WSDL
     * - documentation: "DayOfWeekInd" is used to return the day of the week indicator
     * - use: optional
     * @var string
     */
    public $DayOfWeekInd;
    /**
     * The LinkCode
     * Meta informations extracted from the WSDL
     * - documentation: "LinkCode" is used to return the link code
     * - use: optional
     * @var string
     */
    public $LinkCode;
    /**
     * The MergedSegmentInd
     * Meta informations extracted from the WSDL
     * - documentation: "MergedSegmentInd" is used to return the merged segment indicator associated with the particular itinerary segment if applicable.
     * - use: optional
     * @var string
     */
    public $MergedSegmentInd;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - documentation: "NumberInParty" is used to return the number of passengers associated with the particular hotel segment.
     * - use: optional
     * @var string
     */
    public $NumberInParty;
    /**
     * The NumberOfUnits
     * Meta informations extracted from the WSDL
     * - documentation: "NumberOfUnits" is used to return the number of rooms associated with the particular hotel segment.
     * - use: optional
     * @var string
     */
    public $NumberOfUnits;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the segment type .
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: IsPast attribute is populated based on Hotel - TimeSpan - @End, Hotel - BasicPropertyInfo - @HotelCityCode.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: "Id" is used to return the id of Hotel
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Hotel
     * @uses Hotel::setBasicPropertyInfo()
     * @uses Hotel::setCustomer()
     * @uses Hotel::setGuarantee()
     * @uses Hotel::setPOS()
     * @uses Hotel::setRoomRates()
     * @uses Hotel::setSpecialPrefs()
     * @uses Hotel::setText()
     * @uses Hotel::setTimeSpan()
     * @uses Hotel::setDayOfWeekInd()
     * @uses Hotel::setLinkCode()
     * @uses Hotel::setMergedSegmentInd()
     * @uses Hotel::setNumberInParty()
     * @uses Hotel::setNumberOfUnits()
     * @uses Hotel::setSegmentNumber()
     * @uses Hotel::setStatus()
     * @uses Hotel::setType()
     * @uses Hotel::setIsPast()
     * @uses Hotel::setId()
     * @param \Sabre\TravelItineraryRead\Structs\BasicPropertyInfo $basicPropertyInfo
     * @param \Sabre\TravelItineraryRead\Structs\Customer $customer
     * @param string $guarantee
     * @param \Sabre\TravelItineraryRead\Structs\POS $pOS
     * @param \Sabre\TravelItineraryRead\Structs\RoomRates $roomRates
     * @param \Sabre\TravelItineraryRead\Structs\SpecialPrefs $specialPrefs
     * @param string[] $text
     * @param \Sabre\TravelItineraryRead\Structs\TimeSpan $timeSpan
     * @param string $dayOfWeekInd
     * @param string $linkCode
     * @param string $mergedSegmentInd
     * @param string $numberInParty
     * @param string $numberOfUnits
     * @param string $segmentNumber
     * @param string $status
     * @param string $type
     * @param bool $isPast
     * @param string $id
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\BasicPropertyInfo $basicPropertyInfo = null, \Sabre\TravelItineraryRead\Structs\Customer $customer = null, $guarantee = null, \Sabre\TravelItineraryRead\Structs\POS $pOS = null, \Sabre\TravelItineraryRead\Structs\RoomRates $roomRates = null, \Sabre\TravelItineraryRead\Structs\SpecialPrefs $specialPrefs = null, array $text = array(), \Sabre\TravelItineraryRead\Structs\TimeSpan $timeSpan = null, $dayOfWeekInd = null, $linkCode = null, $mergedSegmentInd = null, $numberInParty = null, $numberOfUnits = null, $segmentNumber = null, $status = null, $type = null, $isPast = null, $id = null)
    {
        $this
            ->setBasicPropertyInfo($basicPropertyInfo)
            ->setCustomer($customer)
            ->setGuarantee($guarantee)
            ->setPOS($pOS)
            ->setRoomRates($roomRates)
            ->setSpecialPrefs($specialPrefs)
            ->setText($text)
            ->setTimeSpan($timeSpan)
            ->setDayOfWeekInd($dayOfWeekInd)
            ->setLinkCode($linkCode)
            ->setMergedSegmentInd($mergedSegmentInd)
            ->setNumberInParty($numberInParty)
            ->setNumberOfUnits($numberOfUnits)
            ->setSegmentNumber($segmentNumber)
            ->setStatus($status)
            ->setType($type)
            ->setIsPast($isPast)
            ->setId($id);
    }
    /**
     * Get BasicPropertyInfo value
     * @return \Sabre\TravelItineraryRead\Structs\BasicPropertyInfo|null
     */
    public function getBasicPropertyInfo()
    {
        return $this->BasicPropertyInfo;
    }
    /**
     * Set BasicPropertyInfo value
     * @param \Sabre\TravelItineraryRead\Structs\BasicPropertyInfo $basicPropertyInfo
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setBasicPropertyInfo(\Sabre\TravelItineraryRead\Structs\BasicPropertyInfo $basicPropertyInfo = null)
    {
        $this->BasicPropertyInfo = $basicPropertyInfo;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Sabre\TravelItineraryRead\Structs\Customer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Sabre\TravelItineraryRead\Structs\Customer $customer
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setCustomer(\Sabre\TravelItineraryRead\Structs\Customer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return string|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @param string $guarantee
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setGuarantee($guarantee = null)
    {
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Get POS value
     * @return \Sabre\TravelItineraryRead\Structs\POS|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \Sabre\TravelItineraryRead\Structs\POS $pOS
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setPOS(\Sabre\TravelItineraryRead\Structs\POS $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get RoomRates value
     * @return \Sabre\TravelItineraryRead\Structs\RoomRates|null
     */
    public function getRoomRates()
    {
        return $this->RoomRates;
    }
    /**
     * Set RoomRates value
     * @param \Sabre\TravelItineraryRead\Structs\RoomRates $roomRates
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setRoomRates(\Sabre\TravelItineraryRead\Structs\RoomRates $roomRates = null)
    {
        $this->RoomRates = $roomRates;
        return $this;
    }
    /**
     * Get SpecialPrefs value
     * @return \Sabre\TravelItineraryRead\Structs\SpecialPrefs|null
     */
    public function getSpecialPrefs()
    {
        return $this->SpecialPrefs;
    }
    /**
     * Set SpecialPrefs value
     * @param \Sabre\TravelItineraryRead\Structs\SpecialPrefs $specialPrefs
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setSpecialPrefs(\Sabre\TravelItineraryRead\Structs\SpecialPrefs $specialPrefs = null)
    {
        $this->SpecialPrefs = $specialPrefs;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \Sabre\TravelItineraryRead\Structs\TimeSpan|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \Sabre\TravelItineraryRead\Structs\TimeSpan $timeSpan
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setTimeSpan(\Sabre\TravelItineraryRead\Structs\TimeSpan $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get DayOfWeekInd value
     * @return string|null
     */
    public function getDayOfWeekInd()
    {
        return $this->DayOfWeekInd;
    }
    /**
     * Set DayOfWeekInd value
     * @param string $dayOfWeekInd
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setDayOfWeekInd($dayOfWeekInd = null)
    {
        $this->DayOfWeekInd = $dayOfWeekInd;
        return $this;
    }
    /**
     * Get LinkCode value
     * @return string|null
     */
    public function getLinkCode()
    {
        return $this->LinkCode;
    }
    /**
     * Set LinkCode value
     * @param string $linkCode
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setLinkCode($linkCode = null)
    {
        $this->LinkCode = $linkCode;
        return $this;
    }
    /**
     * Get MergedSegmentInd value
     * @return string|null
     */
    public function getMergedSegmentInd()
    {
        return $this->MergedSegmentInd;
    }
    /**
     * Set MergedSegmentInd value
     * @param string $mergedSegmentInd
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setMergedSegmentInd($mergedSegmentInd = null)
    {
        $this->MergedSegmentInd = $mergedSegmentInd;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return string|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param string $numberInParty
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return string|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param string $numberOfUnits
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Hotel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
