<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Docket Structs
 * @subpackage Structs
 */
class Docket extends AbstractStructBase
{
    /**
     * The DocketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DocketNumber;
    /**
     * The Prefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Prefix;
    /**
     * The AgentInitials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentInitials;
    /**
     * The BNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BNumber;
    /**
     * Constructor method for Docket
     * @uses Docket::setDocketNumber()
     * @uses Docket::setPrefix()
     * @uses Docket::setAgentInitials()
     * @uses Docket::setBNumber()
     * @param string $docketNumber
     * @param string $prefix
     * @param string $agentInitials
     * @param string $bNumber
     */
    public function __construct($docketNumber = null, $prefix = null, $agentInitials = null, $bNumber = null)
    {
        $this
            ->setDocketNumber($docketNumber)
            ->setPrefix($prefix)
            ->setAgentInitials($agentInitials)
            ->setBNumber($bNumber);
    }
    /**
     * Get DocketNumber value
     * @return string
     */
    public function getDocketNumber()
    {
        return $this->DocketNumber;
    }
    /**
     * Set DocketNumber value
     * @param string $docketNumber
     * @return \Sabre\TravelItineraryRead\Structs\Docket
     */
    public function setDocketNumber($docketNumber = null)
    {
        $this->DocketNumber = $docketNumber;
        return $this;
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \Sabre\TravelItineraryRead\Structs\Docket
     */
    public function setPrefix($prefix = null)
    {
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Get AgentInitials value
     * @return string|null
     */
    public function getAgentInitials()
    {
        return $this->AgentInitials;
    }
    /**
     * Set AgentInitials value
     * @param string $agentInitials
     * @return \Sabre\TravelItineraryRead\Structs\Docket
     */
    public function setAgentInitials($agentInitials = null)
    {
        $this->AgentInitials = $agentInitials;
        return $this;
    }
    /**
     * Get BNumber value
     * @return string|null
     */
    public function getBNumber()
    {
        return $this->BNumber;
    }
    /**
     * Set BNumber value
     * @param string $bNumber
     * @return \Sabre\TravelItineraryRead\Structs\Docket
     */
    public function setBNumber($bNumber = null)
    {
        $this->BNumber = $bNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Docket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
