<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyType Structs
 * @subpackage Structs
 */
class CompanyType extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Code
     */
    public $Code;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PhoneType[]
     */
    public $Telephone;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AddressType[]
     */
    public $Address;
    /**
     * Constructor method for CompanyType
     * @uses CompanyType::setName()
     * @uses CompanyType::setCode()
     * @uses CompanyType::setTelephone()
     * @uses CompanyType::setAddress()
     * @param string $name
     * @param \Sabre\TravelItineraryRead\Structs\Code $code
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType[] $telephone
     * @param \Sabre\TravelItineraryRead\Structs\AddressType[] $address
     */
    public function __construct($name = null, \Sabre\TravelItineraryRead\Structs\Code $code = null, array $telephone = array(), array $address = array())
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setTelephone($telephone)
            ->setAddress($address);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\TravelItineraryRead\Structs\CompanyType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return \Sabre\TravelItineraryRead\Structs\Code|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param \Sabre\TravelItineraryRead\Structs\Code $code
     * @return \Sabre\TravelItineraryRead\Structs\CompanyType
     */
    public function setCode(\Sabre\TravelItineraryRead\Structs\Code $code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\TravelItineraryRead\Structs\PhoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType[] $telephone
     * @return \Sabre\TravelItineraryRead\Structs\CompanyType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType $item
     * @return \Sabre\TravelItineraryRead\Structs\CompanyType
     */
    public function addToTelephone(\Sabre\TravelItineraryRead\Structs\PhoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \Sabre\TravelItineraryRead\Structs\AddressType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AddressType[] $address
     * @return \Sabre\TravelItineraryRead\Structs\CompanyType
     */
    public function setAddress(array $address = array())
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AddressType $item
     * @return \Sabre\TravelItineraryRead\Structs\CompanyType
     */
    public function addToAddress(\Sabre\TravelItineraryRead\Structs\AddressType $item)
    {
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\CompanyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
