<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeDetails Structs
 * Meta informations extracted from the WSDL
 * - documentation: Car segment Approximate price fields – ‘/AP-¤USD281.27 UNL 3DY 0HR 41.97SSQ 123.11MC/RC-¤STDR/CF-G31214927E8-‘ | Car segment Approximate price fields – ‘/AP-¤USD281.27 UNL 3DY 0HR 41.97SSQ
 * 123.11MC/RC-¤STDR/CF-G31214927E8-‘
 * @subpackage Structs
 */
class ChargeDetails extends AbstractStructBase
{
    /**
     * The ApproximateTotalCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ApproximateTotalCharge[]
     */
    public $ApproximateTotalCharge;
    /**
     * Constructor method for ChargeDetails
     * @uses ChargeDetails::setApproximateTotalCharge()
     * @param \Sabre\TravelItineraryRead\Structs\ApproximateTotalCharge[] $approximateTotalCharge
     */
    public function __construct(array $approximateTotalCharge = array())
    {
        $this
            ->setApproximateTotalCharge($approximateTotalCharge);
    }
    /**
     * Get ApproximateTotalCharge value
     * @return \Sabre\TravelItineraryRead\Structs\ApproximateTotalCharge[]|null
     */
    public function getApproximateTotalCharge()
    {
        return $this->ApproximateTotalCharge;
    }
    /**
     * Set ApproximateTotalCharge value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\ApproximateTotalCharge[] $approximateTotalCharge
     * @return \Sabre\TravelItineraryRead\Structs\ChargeDetails
     */
    public function setApproximateTotalCharge(array $approximateTotalCharge = array())
    {
        $this->ApproximateTotalCharge = $approximateTotalCharge;
        return $this;
    }
    /**
     * Add item to ApproximateTotalCharge value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\ApproximateTotalCharge $item
     * @return \Sabre\TravelItineraryRead\Structs\ChargeDetails
     */
    public function addToApproximateTotalCharge(\Sabre\TravelItineraryRead\Structs\ApproximateTotalCharge $item)
    {
        $this->ApproximateTotalCharge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\ChargeDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
