<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charge Structs
 * @subpackage Structs
 */
class Charge extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the vehicle charge amount.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Amount;
    /**
     * The ConversionRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ConversionRate
     */
    public $ConversionRate;
    /**
     * The ChargeDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ChargeDetails
     */
    public $ChargeDetails;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Commission
     */
    public $Commission;
    /**
     * The Mileage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Mileage
     */
    public $Mileage;
    /**
     * The ExcessRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ExcessRate
     */
    public $ExcessRate;
    /**
     * The dropOffCharge
     * Meta informations extracted from the WSDL
     * - documentation: "dropOffCharge" is used to return drop off charge amount.
     * - use: optional
     * @var string
     */
    public $dropOffCharge;
    /**
     * The typeOfGuarantee
     * Meta informations extracted from the WSDL
     * - documentation: "typeOfGuarantee" is used to return the type of guarantee associated with the vehicle rental.
     * - use: optional
     * @var string
     */
    public $typeOfGuarantee;
    /**
     * Constructor method for Charge
     * @uses Charge::setAmount()
     * @uses Charge::setConversionRate()
     * @uses Charge::setChargeDetails()
     * @uses Charge::setCommission()
     * @uses Charge::setMileage()
     * @uses Charge::setExcessRate()
     * @uses Charge::setDropOffCharge()
     * @uses Charge::setTypeOfGuarantee()
     * @param string[] $amount
     * @param \Sabre\TravelItineraryRead\Structs\ConversionRate $conversionRate
     * @param \Sabre\TravelItineraryRead\Structs\ChargeDetails $chargeDetails
     * @param \Sabre\TravelItineraryRead\Structs\Commission $commission
     * @param \Sabre\TravelItineraryRead\Structs\Mileage $mileage
     * @param \Sabre\TravelItineraryRead\Structs\ExcessRate $excessRate
     * @param string $dropOffCharge
     * @param string $typeOfGuarantee
     */
    public function __construct(array $amount = array(), \Sabre\TravelItineraryRead\Structs\ConversionRate $conversionRate = null, \Sabre\TravelItineraryRead\Structs\ChargeDetails $chargeDetails = null, \Sabre\TravelItineraryRead\Structs\Commission $commission = null, \Sabre\TravelItineraryRead\Structs\Mileage $mileage = null, \Sabre\TravelItineraryRead\Structs\ExcessRate $excessRate = null, $dropOffCharge = null, $typeOfGuarantee = null)
    {
        $this
            ->setAmount($amount)
            ->setConversionRate($conversionRate)
            ->setChargeDetails($chargeDetails)
            ->setCommission($commission)
            ->setMileage($mileage)
            ->setExcessRate($excessRate)
            ->setDropOffCharge($dropOffCharge)
            ->setTypeOfGuarantee($typeOfGuarantee);
    }
    /**
     * Get Amount value
     * @return string[]|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @throws \InvalidArgumentException
     * @param string[] $amount
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public function setAmount(array $amount = array())
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Add item to Amount value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public function addToAmount($item)
    {
        $this->Amount[] = $item;
        return $this;
    }
    /**
     * Get ConversionRate value
     * @return \Sabre\TravelItineraryRead\Structs\ConversionRate|null
     */
    public function getConversionRate()
    {
        return $this->ConversionRate;
    }
    /**
     * Set ConversionRate value
     * @param \Sabre\TravelItineraryRead\Structs\ConversionRate $conversionRate
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public function setConversionRate(\Sabre\TravelItineraryRead\Structs\ConversionRate $conversionRate = null)
    {
        $this->ConversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get ChargeDetails value
     * @return \Sabre\TravelItineraryRead\Structs\ChargeDetails|null
     */
    public function getChargeDetails()
    {
        return $this->ChargeDetails;
    }
    /**
     * Set ChargeDetails value
     * @param \Sabre\TravelItineraryRead\Structs\ChargeDetails $chargeDetails
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public function setChargeDetails(\Sabre\TravelItineraryRead\Structs\ChargeDetails $chargeDetails = null)
    {
        $this->ChargeDetails = $chargeDetails;
        return $this;
    }
    /**
     * Get Commission value
     * @return \Sabre\TravelItineraryRead\Structs\Commission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \Sabre\TravelItineraryRead\Structs\Commission $commission
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public function setCommission(\Sabre\TravelItineraryRead\Structs\Commission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get Mileage value
     * @return \Sabre\TravelItineraryRead\Structs\Mileage|null
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param \Sabre\TravelItineraryRead\Structs\Mileage $mileage
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public function setMileage(\Sabre\TravelItineraryRead\Structs\Mileage $mileage = null)
    {
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get ExcessRate value
     * @return \Sabre\TravelItineraryRead\Structs\ExcessRate|null
     */
    public function getExcessRate()
    {
        return $this->ExcessRate;
    }
    /**
     * Set ExcessRate value
     * @param \Sabre\TravelItineraryRead\Structs\ExcessRate $excessRate
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public function setExcessRate(\Sabre\TravelItineraryRead\Structs\ExcessRate $excessRate = null)
    {
        $this->ExcessRate = $excessRate;
        return $this;
    }
    /**
     * Get dropOffCharge value
     * @return string|null
     */
    public function getDropOffCharge()
    {
        return $this->dropOffCharge;
    }
    /**
     * Set dropOffCharge value
     * @param string $dropOffCharge
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public function setDropOffCharge($dropOffCharge = null)
    {
        $this->dropOffCharge = $dropOffCharge;
        return $this;
    }
    /**
     * Get typeOfGuarantee value
     * @return string|null
     */
    public function getTypeOfGuarantee()
    {
        return $this->typeOfGuarantee;
    }
    /**
     * Set typeOfGuarantee value
     * @param string $typeOfGuarantee
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public function setTypeOfGuarantee($typeOfGuarantee = null)
    {
        $this->typeOfGuarantee = $typeOfGuarantee;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Charge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
