<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryTax Structs
 * @subpackage Structs
 */
class AncillaryTax extends AbstractStructBase
{
    /**
     * The TaxAmount
     * @var float
     */
    public $TaxAmount;
    /**
     * The TaxCode
     * @var CommonString
     */
    public $TaxCode;
    /**
     * Constructor method for AncillaryTax
     * @uses AncillaryTax::setTaxAmount()
     * @uses AncillaryTax::setTaxCode()
     * @param float $taxAmount
     * @param CommonString $taxCode
     */
    public function __construct($taxAmount = null, CommonString $taxCode = null)
    {
        $this
            ->setTaxAmount($taxAmount)
            ->setTaxCode($taxCode);
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryTax
     */
    public function setTaxAmount($taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return CommonString|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param CommonString $taxCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryTax
     */
    public function setTaxCode(CommonString $taxCode = null)
    {
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryTax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
