<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirType Structs
 * @subpackage Structs
 */
class AirType extends AbstractStructBase
{
    /**
     * The DepartureAirport
     * @var CommonString
     */
    public $DepartureAirport;
    /**
     * The DepartureAirportCodeContext
     * @var string
     */
    public $DepartureAirportCodeContext;
    /**
     * The DepartureTerminalName
     * @var string
     */
    public $DepartureTerminalName;
    /**
     * The DepartureTerminalCode
     * @var string
     */
    public $DepartureTerminalCode;
    /**
     * The ArrivalAirport
     * @var CommonString
     */
    public $ArrivalAirport;
    /**
     * The ArrivalAirportCodeContext
     * @var string
     */
    public $ArrivalAirportCodeContext;
    /**
     * The ArrivalTerminalName
     * @var string
     */
    public $ArrivalTerminalName;
    /**
     * The ArrivalTerminalCode
     * @var string
     */
    public $ArrivalTerminalCode;
    /**
     * The OperatingAirlineCode
     * @var AirlineCode
     */
    public $OperatingAirlineCode;
    /**
     * The OperatingAirlineShortName
     * @var string
     */
    public $OperatingAirlineShortName;
    /**
     * The OperatingFlightNumber
     * @var string
     */
    public $OperatingFlightNumber;
    /**
     * The EquipmentType
     * @var CommonString
     */
    public $EquipmentType;
    /**
     * The MarketingAirlineCode
     * @var string
     */
    public $MarketingAirlineCode;
    /**
     * The MarketingFlightNumber
     * @var string
     */
    public $MarketingFlightNumber;
    /**
     * The OperatingClassOfService
     * @var CommonString
     */
    public $OperatingClassOfService;
    /**
     * The MarketingClassOfService
     * @var CommonString
     */
    public $MarketingClassOfService;
    /**
     * The CodeShareOperatingRecordLocator
     * @var CommonString
     */
    public $CodeShareOperatingRecordLocator;
    /**
     * The MarriageGrp
     * @var \Sabre\TravelItineraryRead\Structs\MarriageGrp
     */
    public $MarriageGrp;
    /**
     * The AirlineRefId
     * @var string
     */
    public $AirlineRefId;
    /**
     * The Eticket
     * @var bool
     */
    public $Eticket;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * The ClassOfService
     * @var CommonString
     */
    public $ClassOfService;
    /**
     * The ActionCode
     * @var CommonString
     */
    public $ActionCode;
    /**
     * The NumberInParty
     * @var Numeric0to99999
     */
    public $NumberInParty;
    /**
     * The inboundConnection
     * @var bool
     */
    public $inboundConnection;
    /**
     * The outboundConnection
     * @var bool
     */
    public $outboundConnection;
    /**
     * The AncillaryServices
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryServices
     */
    public $AncillaryServices;
    /**
     * The BSGIndicator
     * @var bool
     */
    public $BSGIndicator;
    /**
     * The BSGPNRRecordLocator
     * @var CommonString
     */
    public $BSGPNRRecordLocator;
    /**
     * The BSGPNRCreatedDate
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $BSGPNRCreatedDate;
    /**
     * The PassiveSegmentIndicator
     * @var bool
     */
    public $PassiveSegmentIndicator;
    /**
     * The ScheduleChangeIndicator
     * @var bool
     */
    public $ScheduleChangeIndicator;
    /**
     * The SegmentBookedDate
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $SegmentBookedDate;
    /**
     * The UpdatedDepartureDate
     * @var string
     */
    public $UpdatedDepartureDate;
    /**
     * The UpdatedDepartureTime
     * @var string
     */
    public $UpdatedDepartureTime;
    /**
     * The UpdatedArrivalTime
     * @var string
     */
    public $UpdatedArrivalTime;
    /**
     * The Pos
     * @var \Sabre\TravelItineraryRead\Structs\AirPosType
     */
    public $Pos;
    /**
     * The OALocator
     * @var string
     */
    public $OALocator;
    /**
     * The DirectConnectDate
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $DirectConnectDate;
    /**
     * The InstantPurchase
     * @var bool
     */
    public $InstantPurchase;
    /**
     * The BrandID
     * @var BrandIDType
     */
    public $BrandID;
    /**
     * The index
     * @var Numeric0to99999
     */
    public $index;
    /**
     * The sequence
     * @var int
     */
    public $sequence;
    /**
     * The segmentAssociationId
     * @var int
     */
    public $segmentAssociationId;
    /**
     * The isPast
     * @var bool
     */
    public $isPast;
    /**
     * Constructor method for AirType
     * @uses AirType::setDepartureAirport()
     * @uses AirType::setDepartureAirportCodeContext()
     * @uses AirType::setDepartureTerminalName()
     * @uses AirType::setDepartureTerminalCode()
     * @uses AirType::setArrivalAirport()
     * @uses AirType::setArrivalAirportCodeContext()
     * @uses AirType::setArrivalTerminalName()
     * @uses AirType::setArrivalTerminalCode()
     * @uses AirType::setOperatingAirlineCode()
     * @uses AirType::setOperatingAirlineShortName()
     * @uses AirType::setOperatingFlightNumber()
     * @uses AirType::setEquipmentType()
     * @uses AirType::setMarketingAirlineCode()
     * @uses AirType::setMarketingFlightNumber()
     * @uses AirType::setOperatingClassOfService()
     * @uses AirType::setMarketingClassOfService()
     * @uses AirType::setCodeShareOperatingRecordLocator()
     * @uses AirType::setMarriageGrp()
     * @uses AirType::setAirlineRefId()
     * @uses AirType::setEticket()
     * @uses AirType::setDepartureDateTime()
     * @uses AirType::setArrivalDateTime()
     * @uses AirType::setFlightNumber()
     * @uses AirType::setClassOfService()
     * @uses AirType::setActionCode()
     * @uses AirType::setNumberInParty()
     * @uses AirType::setInboundConnection()
     * @uses AirType::setOutboundConnection()
     * @uses AirType::setAncillaryServices()
     * @uses AirType::setBSGIndicator()
     * @uses AirType::setBSGPNRRecordLocator()
     * @uses AirType::setBSGPNRCreatedDate()
     * @uses AirType::setPassiveSegmentIndicator()
     * @uses AirType::setScheduleChangeIndicator()
     * @uses AirType::setSegmentBookedDate()
     * @uses AirType::setUpdatedDepartureDate()
     * @uses AirType::setUpdatedDepartureTime()
     * @uses AirType::setUpdatedArrivalTime()
     * @uses AirType::setPos()
     * @uses AirType::setOALocator()
     * @uses AirType::setDirectConnectDate()
     * @uses AirType::setInstantPurchase()
     * @uses AirType::setBrandID()
     * @uses AirType::setIndex()
     * @uses AirType::setSequence()
     * @uses AirType::setSegmentAssociationId()
     * @uses AirType::setIsPast()
     * @param CommonString $departureAirport
     * @param string $departureAirportCodeContext
     * @param string $departureTerminalName
     * @param string $departureTerminalCode
     * @param CommonString $arrivalAirport
     * @param string $arrivalAirportCodeContext
     * @param string $arrivalTerminalName
     * @param string $arrivalTerminalCode
     * @param AirlineCode $operatingAirlineCode
     * @param string $operatingAirlineShortName
     * @param string $operatingFlightNumber
     * @param CommonString $equipmentType
     * @param string $marketingAirlineCode
     * @param string $marketingFlightNumber
     * @param CommonString $operatingClassOfService
     * @param CommonString $marketingClassOfService
     * @param CommonString $codeShareOperatingRecordLocator
     * @param \Sabre\TravelItineraryRead\Structs\MarriageGrp $marriageGrp
     * @param string $airlineRefId
     * @param bool $eticket
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param string $flightNumber
     * @param CommonString $classOfService
     * @param CommonString $actionCode
     * @param Numeric0to99999 $numberInParty
     * @param bool $inboundConnection
     * @param bool $outboundConnection
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryServices $ancillaryServices
     * @param bool $bSGIndicator
     * @param CommonString $bSGPNRRecordLocator
     * @param string $bSGPNRCreatedDate
     * @param bool $passiveSegmentIndicator
     * @param bool $scheduleChangeIndicator
     * @param string $segmentBookedDate
     * @param string $updatedDepartureDate
     * @param string $updatedDepartureTime
     * @param string $updatedArrivalTime
     * @param \Sabre\TravelItineraryRead\Structs\AirPosType $pos
     * @param string $oALocator
     * @param string $directConnectDate
     * @param bool $instantPurchase
     * @param BrandIDType $brandID
     * @param Numeric0to99999 $index
     * @param int $sequence
     * @param int $segmentAssociationId
     * @param bool $isPast
     */
    public function __construct(CommonString $departureAirport = null, $departureAirportCodeContext = null, $departureTerminalName = null, $departureTerminalCode = null, CommonString $arrivalAirport = null, $arrivalAirportCodeContext = null, $arrivalTerminalName = null, $arrivalTerminalCode = null, AirlineCode $operatingAirlineCode = null, $operatingAirlineShortName = null, $operatingFlightNumber = null, CommonString $equipmentType = null, $marketingAirlineCode = null, $marketingFlightNumber = null, CommonString $operatingClassOfService = null, CommonString $marketingClassOfService = null, CommonString $codeShareOperatingRecordLocator = null, \Sabre\TravelItineraryRead\Structs\MarriageGrp $marriageGrp = null, $airlineRefId = null, $eticket = null, $departureDateTime = null, $arrivalDateTime = null, $flightNumber = null, CommonString $classOfService = null, CommonString $actionCode = null, Numeric0to99999 $numberInParty = null, $inboundConnection = null, $outboundConnection = null, \Sabre\TravelItineraryRead\Structs\AncillaryServices $ancillaryServices = null, $bSGIndicator = null, CommonString $bSGPNRRecordLocator = null, $bSGPNRCreatedDate = null, $passiveSegmentIndicator = null, $scheduleChangeIndicator = null, $segmentBookedDate = null, $updatedDepartureDate = null, $updatedDepartureTime = null, $updatedArrivalTime = null, \Sabre\TravelItineraryRead\Structs\AirPosType $pos = null, $oALocator = null, $directConnectDate = null, $instantPurchase = null, BrandIDType $brandID = null, Numeric0to99999 $index = null, $sequence = null, $segmentAssociationId = null, $isPast = null)
    {
        $this
            ->setDepartureAirport($departureAirport)
            ->setDepartureAirportCodeContext($departureAirportCodeContext)
            ->setDepartureTerminalName($departureTerminalName)
            ->setDepartureTerminalCode($departureTerminalCode)
            ->setArrivalAirport($arrivalAirport)
            ->setArrivalAirportCodeContext($arrivalAirportCodeContext)
            ->setArrivalTerminalName($arrivalTerminalName)
            ->setArrivalTerminalCode($arrivalTerminalCode)
            ->setOperatingAirlineCode($operatingAirlineCode)
            ->setOperatingAirlineShortName($operatingAirlineShortName)
            ->setOperatingFlightNumber($operatingFlightNumber)
            ->setEquipmentType($equipmentType)
            ->setMarketingAirlineCode($marketingAirlineCode)
            ->setMarketingFlightNumber($marketingFlightNumber)
            ->setOperatingClassOfService($operatingClassOfService)
            ->setMarketingClassOfService($marketingClassOfService)
            ->setCodeShareOperatingRecordLocator($codeShareOperatingRecordLocator)
            ->setMarriageGrp($marriageGrp)
            ->setAirlineRefId($airlineRefId)
            ->setEticket($eticket)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setFlightNumber($flightNumber)
            ->setClassOfService($classOfService)
            ->setActionCode($actionCode)
            ->setNumberInParty($numberInParty)
            ->setInboundConnection($inboundConnection)
            ->setOutboundConnection($outboundConnection)
            ->setAncillaryServices($ancillaryServices)
            ->setBSGIndicator($bSGIndicator)
            ->setBSGPNRRecordLocator($bSGPNRRecordLocator)
            ->setBSGPNRCreatedDate($bSGPNRCreatedDate)
            ->setPassiveSegmentIndicator($passiveSegmentIndicator)
            ->setScheduleChangeIndicator($scheduleChangeIndicator)
            ->setSegmentBookedDate($segmentBookedDate)
            ->setUpdatedDepartureDate($updatedDepartureDate)
            ->setUpdatedDepartureTime($updatedDepartureTime)
            ->setUpdatedArrivalTime($updatedArrivalTime)
            ->setPos($pos)
            ->setOALocator($oALocator)
            ->setDirectConnectDate($directConnectDate)
            ->setInstantPurchase($instantPurchase)
            ->setBrandID($brandID)
            ->setIndex($index)
            ->setSequence($sequence)
            ->setSegmentAssociationId($segmentAssociationId)
            ->setIsPast($isPast);
    }
    /**
     * Get DepartureAirport value
     * @return CommonString|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param CommonString $departureAirport
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setDepartureAirport(CommonString $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get DepartureAirportCodeContext value
     * @return string|null
     */
    public function getDepartureAirportCodeContext()
    {
        return $this->DepartureAirportCodeContext;
    }
    /**
     * Set DepartureAirportCodeContext value
     * @param string $departureAirportCodeContext
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setDepartureAirportCodeContext($departureAirportCodeContext = null)
    {
        $this->DepartureAirportCodeContext = $departureAirportCodeContext;
        return $this;
    }
    /**
     * Get DepartureTerminalName value
     * @return string|null
     */
    public function getDepartureTerminalName()
    {
        return $this->DepartureTerminalName;
    }
    /**
     * Set DepartureTerminalName value
     * @param string $departureTerminalName
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setDepartureTerminalName($departureTerminalName = null)
    {
        $this->DepartureTerminalName = $departureTerminalName;
        return $this;
    }
    /**
     * Get DepartureTerminalCode value
     * @return string|null
     */
    public function getDepartureTerminalCode()
    {
        return $this->DepartureTerminalCode;
    }
    /**
     * Set DepartureTerminalCode value
     * @param string $departureTerminalCode
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setDepartureTerminalCode($departureTerminalCode = null)
    {
        $this->DepartureTerminalCode = $departureTerminalCode;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return CommonString|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param CommonString $arrivalAirport
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setArrivalAirport(CommonString $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get ArrivalAirportCodeContext value
     * @return string|null
     */
    public function getArrivalAirportCodeContext()
    {
        return $this->ArrivalAirportCodeContext;
    }
    /**
     * Set ArrivalAirportCodeContext value
     * @param string $arrivalAirportCodeContext
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setArrivalAirportCodeContext($arrivalAirportCodeContext = null)
    {
        $this->ArrivalAirportCodeContext = $arrivalAirportCodeContext;
        return $this;
    }
    /**
     * Get ArrivalTerminalName value
     * @return string|null
     */
    public function getArrivalTerminalName()
    {
        return $this->ArrivalTerminalName;
    }
    /**
     * Set ArrivalTerminalName value
     * @param string $arrivalTerminalName
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setArrivalTerminalName($arrivalTerminalName = null)
    {
        $this->ArrivalTerminalName = $arrivalTerminalName;
        return $this;
    }
    /**
     * Get ArrivalTerminalCode value
     * @return string|null
     */
    public function getArrivalTerminalCode()
    {
        return $this->ArrivalTerminalCode;
    }
    /**
     * Set ArrivalTerminalCode value
     * @param string $arrivalTerminalCode
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setArrivalTerminalCode($arrivalTerminalCode = null)
    {
        $this->ArrivalTerminalCode = $arrivalTerminalCode;
        return $this;
    }
    /**
     * Get OperatingAirlineCode value
     * @return AirlineCode|null
     */
    public function getOperatingAirlineCode()
    {
        return $this->OperatingAirlineCode;
    }
    /**
     * Set OperatingAirlineCode value
     * @param AirlineCode $operatingAirlineCode
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setOperatingAirlineCode(AirlineCode $operatingAirlineCode = null)
    {
        $this->OperatingAirlineCode = $operatingAirlineCode;
        return $this;
    }
    /**
     * Get OperatingAirlineShortName value
     * @return string|null
     */
    public function getOperatingAirlineShortName()
    {
        return $this->OperatingAirlineShortName;
    }
    /**
     * Set OperatingAirlineShortName value
     * @param string $operatingAirlineShortName
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setOperatingAirlineShortName($operatingAirlineShortName = null)
    {
        $this->OperatingAirlineShortName = $operatingAirlineShortName;
        return $this;
    }
    /**
     * Get OperatingFlightNumber value
     * @return string|null
     */
    public function getOperatingFlightNumber()
    {
        return $this->OperatingFlightNumber;
    }
    /**
     * Set OperatingFlightNumber value
     * @param string $operatingFlightNumber
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setOperatingFlightNumber($operatingFlightNumber = null)
    {
        $this->OperatingFlightNumber = $operatingFlightNumber;
        return $this;
    }
    /**
     * Get EquipmentType value
     * @return CommonString|null
     */
    public function getEquipmentType()
    {
        return $this->EquipmentType;
    }
    /**
     * Set EquipmentType value
     * @param CommonString $equipmentType
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setEquipmentType(CommonString $equipmentType = null)
    {
        $this->EquipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get MarketingAirlineCode value
     * @return string|null
     */
    public function getMarketingAirlineCode()
    {
        return $this->MarketingAirlineCode;
    }
    /**
     * Set MarketingAirlineCode value
     * @param string $marketingAirlineCode
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setMarketingAirlineCode($marketingAirlineCode = null)
    {
        $this->MarketingAirlineCode = $marketingAirlineCode;
        return $this;
    }
    /**
     * Get MarketingFlightNumber value
     * @return string|null
     */
    public function getMarketingFlightNumber()
    {
        return $this->MarketingFlightNumber;
    }
    /**
     * Set MarketingFlightNumber value
     * @param string $marketingFlightNumber
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setMarketingFlightNumber($marketingFlightNumber = null)
    {
        $this->MarketingFlightNumber = $marketingFlightNumber;
        return $this;
    }
    /**
     * Get OperatingClassOfService value
     * @return CommonString|null
     */
    public function getOperatingClassOfService()
    {
        return $this->OperatingClassOfService;
    }
    /**
     * Set OperatingClassOfService value
     * @param CommonString $operatingClassOfService
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setOperatingClassOfService(CommonString $operatingClassOfService = null)
    {
        $this->OperatingClassOfService = $operatingClassOfService;
        return $this;
    }
    /**
     * Get MarketingClassOfService value
     * @return CommonString|null
     */
    public function getMarketingClassOfService()
    {
        return $this->MarketingClassOfService;
    }
    /**
     * Set MarketingClassOfService value
     * @param CommonString $marketingClassOfService
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setMarketingClassOfService(CommonString $marketingClassOfService = null)
    {
        $this->MarketingClassOfService = $marketingClassOfService;
        return $this;
    }
    /**
     * Get CodeShareOperatingRecordLocator value
     * @return CommonString|null
     */
    public function getCodeShareOperatingRecordLocator()
    {
        return $this->CodeShareOperatingRecordLocator;
    }
    /**
     * Set CodeShareOperatingRecordLocator value
     * @param CommonString $codeShareOperatingRecordLocator
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setCodeShareOperatingRecordLocator(CommonString $codeShareOperatingRecordLocator = null)
    {
        $this->CodeShareOperatingRecordLocator = $codeShareOperatingRecordLocator;
        return $this;
    }
    /**
     * Get MarriageGrp value
     * @return \Sabre\TravelItineraryRead\Structs\MarriageGrp|null
     */
    public function getMarriageGrp()
    {
        return $this->MarriageGrp;
    }
    /**
     * Set MarriageGrp value
     * @param \Sabre\TravelItineraryRead\Structs\MarriageGrp $marriageGrp
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setMarriageGrp(\Sabre\TravelItineraryRead\Structs\MarriageGrp $marriageGrp = null)
    {
        $this->MarriageGrp = $marriageGrp;
        return $this;
    }
    /**
     * Get AirlineRefId value
     * @return string|null
     */
    public function getAirlineRefId()
    {
        return $this->AirlineRefId;
    }
    /**
     * Set AirlineRefId value
     * @param string $airlineRefId
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setAirlineRefId($airlineRefId = null)
    {
        $this->AirlineRefId = $airlineRefId;
        return $this;
    }
    /**
     * Get Eticket value
     * @return bool|null
     */
    public function getEticket()
    {
        return $this->Eticket;
    }
    /**
     * Set Eticket value
     * @param bool $eticket
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setEticket($eticket = null)
    {
        $this->Eticket = $eticket;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return CommonString|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param CommonString $classOfService
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setClassOfService(CommonString $classOfService = null)
    {
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return CommonString|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param CommonString $actionCode
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setActionCode(CommonString $actionCode = null)
    {
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return Numeric0to99999|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param Numeric0to99999 $numberInParty
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setNumberInParty(Numeric0to99999 $numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get inboundConnection value
     * @return bool|null
     */
    public function getInboundConnection()
    {
        return $this->inboundConnection;
    }
    /**
     * Set inboundConnection value
     * @param bool $inboundConnection
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setInboundConnection($inboundConnection = null)
    {
        $this->inboundConnection = $inboundConnection;
        return $this;
    }
    /**
     * Get outboundConnection value
     * @return bool|null
     */
    public function getOutboundConnection()
    {
        return $this->outboundConnection;
    }
    /**
     * Set outboundConnection value
     * @param bool $outboundConnection
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setOutboundConnection($outboundConnection = null)
    {
        $this->outboundConnection = $outboundConnection;
        return $this;
    }
    /**
     * Get AncillaryServices value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServices|null
     */
    public function getAncillaryServices()
    {
        return $this->AncillaryServices;
    }
    /**
     * Set AncillaryServices value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryServices $ancillaryServices
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setAncillaryServices(\Sabre\TravelItineraryRead\Structs\AncillaryServices $ancillaryServices = null)
    {
        $this->AncillaryServices = $ancillaryServices;
        return $this;
    }
    /**
     * Get BSGIndicator value
     * @return bool|null
     */
    public function getBSGIndicator()
    {
        return $this->BSGIndicator;
    }
    /**
     * Set BSGIndicator value
     * @param bool $bSGIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setBSGIndicator($bSGIndicator = null)
    {
        $this->BSGIndicator = $bSGIndicator;
        return $this;
    }
    /**
     * Get BSGPNRRecordLocator value
     * @return CommonString|null
     */
    public function getBSGPNRRecordLocator()
    {
        return $this->BSGPNRRecordLocator;
    }
    /**
     * Set BSGPNRRecordLocator value
     * @param CommonString $bSGPNRRecordLocator
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setBSGPNRRecordLocator(CommonString $bSGPNRRecordLocator = null)
    {
        $this->BSGPNRRecordLocator = $bSGPNRRecordLocator;
        return $this;
    }
    /**
     * Get BSGPNRCreatedDate value
     * @return string|null
     */
    public function getBSGPNRCreatedDate()
    {
        return $this->BSGPNRCreatedDate;
    }
    /**
     * Set BSGPNRCreatedDate value
     * @param string $bSGPNRCreatedDate
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setBSGPNRCreatedDate($bSGPNRCreatedDate = null)
    {
        $this->BSGPNRCreatedDate = $bSGPNRCreatedDate;
        return $this;
    }
    /**
     * Get PassiveSegmentIndicator value
     * @return bool|null
     */
    public function getPassiveSegmentIndicator()
    {
        return $this->PassiveSegmentIndicator;
    }
    /**
     * Set PassiveSegmentIndicator value
     * @param bool $passiveSegmentIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setPassiveSegmentIndicator($passiveSegmentIndicator = null)
    {
        $this->PassiveSegmentIndicator = $passiveSegmentIndicator;
        return $this;
    }
    /**
     * Get ScheduleChangeIndicator value
     * @return bool|null
     */
    public function getScheduleChangeIndicator()
    {
        return $this->ScheduleChangeIndicator;
    }
    /**
     * Set ScheduleChangeIndicator value
     * @param bool $scheduleChangeIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setScheduleChangeIndicator($scheduleChangeIndicator = null)
    {
        $this->ScheduleChangeIndicator = $scheduleChangeIndicator;
        return $this;
    }
    /**
     * Get SegmentBookedDate value
     * @return string|null
     */
    public function getSegmentBookedDate()
    {
        return $this->SegmentBookedDate;
    }
    /**
     * Set SegmentBookedDate value
     * @param string $segmentBookedDate
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setSegmentBookedDate($segmentBookedDate = null)
    {
        $this->SegmentBookedDate = $segmentBookedDate;
        return $this;
    }
    /**
     * Get UpdatedDepartureDate value
     * @return string|null
     */
    public function getUpdatedDepartureDate()
    {
        return $this->UpdatedDepartureDate;
    }
    /**
     * Set UpdatedDepartureDate value
     * @param string $updatedDepartureDate
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setUpdatedDepartureDate($updatedDepartureDate = null)
    {
        $this->UpdatedDepartureDate = $updatedDepartureDate;
        return $this;
    }
    /**
     * Get UpdatedDepartureTime value
     * @return string|null
     */
    public function getUpdatedDepartureTime()
    {
        return $this->UpdatedDepartureTime;
    }
    /**
     * Set UpdatedDepartureTime value
     * @param string $updatedDepartureTime
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setUpdatedDepartureTime($updatedDepartureTime = null)
    {
        $this->UpdatedDepartureTime = $updatedDepartureTime;
        return $this;
    }
    /**
     * Get UpdatedArrivalTime value
     * @return string|null
     */
    public function getUpdatedArrivalTime()
    {
        return $this->UpdatedArrivalTime;
    }
    /**
     * Set UpdatedArrivalTime value
     * @param string $updatedArrivalTime
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setUpdatedArrivalTime($updatedArrivalTime = null)
    {
        $this->UpdatedArrivalTime = $updatedArrivalTime;
        return $this;
    }
    /**
     * Get Pos value
     * @return \Sabre\TravelItineraryRead\Structs\AirPosType|null
     */
    public function getPos()
    {
        return $this->Pos;
    }
    /**
     * Set Pos value
     * @param \Sabre\TravelItineraryRead\Structs\AirPosType $pos
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setPos(\Sabre\TravelItineraryRead\Structs\AirPosType $pos = null)
    {
        $this->Pos = $pos;
        return $this;
    }
    /**
     * Get OALocator value
     * @return string|null
     */
    public function getOALocator()
    {
        return $this->OALocator;
    }
    /**
     * Set OALocator value
     * @param string $oALocator
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setOALocator($oALocator = null)
    {
        $this->OALocator = $oALocator;
        return $this;
    }
    /**
     * Get DirectConnectDate value
     * @return string|null
     */
    public function getDirectConnectDate()
    {
        return $this->DirectConnectDate;
    }
    /**
     * Set DirectConnectDate value
     * @param string $directConnectDate
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setDirectConnectDate($directConnectDate = null)
    {
        $this->DirectConnectDate = $directConnectDate;
        return $this;
    }
    /**
     * Get InstantPurchase value
     * @return bool|null
     */
    public function getInstantPurchase()
    {
        return $this->InstantPurchase;
    }
    /**
     * Set InstantPurchase value
     * @param bool $instantPurchase
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setInstantPurchase($instantPurchase = null)
    {
        $this->InstantPurchase = $instantPurchase;
        return $this;
    }
    /**
     * Get BrandID value
     * @return BrandIDType|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param BrandIDType $brandID
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setBrandID(BrandIDType $brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get index value
     * @return Numeric0to99999|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param Numeric0to99999 $index
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setIndex(Numeric0to99999 $index = null)
    {
        $this->index = $index;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get segmentAssociationId value
     * @return int|null
     */
    public function getSegmentAssociationId()
    {
        return $this->segmentAssociationId;
    }
    /**
     * Set segmentAssociationId value
     * @param int $segmentAssociationId
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setSegmentAssociationId($segmentAssociationId = null)
    {
        $this->segmentAssociationId = $segmentAssociationId;
        return $this;
    }
    /**
     * Get isPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->isPast;
    }
    /**
     * Set isPast value
     * @param bool $isPast
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public function setIsPast($isPast = null)
    {
        $this->isPast = $isPast;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AirType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
