<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryPricingInfo Structs
 * @subpackage Structs
 */
class AirItineraryPricingInfo extends AbstractStructBase
{
    /**
     * The ItinTotalFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ItinTotalFare[]
     */
    public $ItinTotalFare;
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PassengerTypeQuantity[]
     */
    public $PassengerTypeQuantity;
    /**
     * The PrivateFareInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PrivateFareInformation
     */
    public $PrivateFareInformation;
    /**
     * The PTC_FareBreakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown[]
     */
    public $PTC_FareBreakdown;
    /**
     * Constructor method for AirItineraryPricingInfo
     * @uses AirItineraryPricingInfo::setItinTotalFare()
     * @uses AirItineraryPricingInfo::setPassengerTypeQuantity()
     * @uses AirItineraryPricingInfo::setPrivateFareInformation()
     * @uses AirItineraryPricingInfo::setPTC_FareBreakdown()
     * @param \Sabre\TravelItineraryRead\Structs\ItinTotalFare[] $itinTotalFare
     * @param \Sabre\TravelItineraryRead\Structs\PassengerTypeQuantity[] $passengerTypeQuantity
     * @param \Sabre\TravelItineraryRead\Structs\PrivateFareInformation $privateFareInformation
     * @param \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown[] $pTC_FareBreakdown
     */
    public function __construct(array $itinTotalFare = array(), array $passengerTypeQuantity = array(), \Sabre\TravelItineraryRead\Structs\PrivateFareInformation $privateFareInformation = null, array $pTC_FareBreakdown = array())
    {
        $this
            ->setItinTotalFare($itinTotalFare)
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setPrivateFareInformation($privateFareInformation)
            ->setPTC_FareBreakdown($pTC_FareBreakdown);
    }
    /**
     * Get ItinTotalFare value
     * @return \Sabre\TravelItineraryRead\Structs\ItinTotalFare[]|null
     */
    public function getItinTotalFare()
    {
        return $this->ItinTotalFare;
    }
    /**
     * Set ItinTotalFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\ItinTotalFare[] $itinTotalFare
     * @return \Sabre\TravelItineraryRead\Structs\AirItineraryPricingInfo
     */
    public function setItinTotalFare(array $itinTotalFare = array())
    {
        $this->ItinTotalFare = $itinTotalFare;
        return $this;
    }
    /**
     * Add item to ItinTotalFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\ItinTotalFare $item
     * @return \Sabre\TravelItineraryRead\Structs\AirItineraryPricingInfo
     */
    public function addToItinTotalFare(\Sabre\TravelItineraryRead\Structs\ItinTotalFare $item)
    {
        $this->ItinTotalFare[] = $item;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \Sabre\TravelItineraryRead\Structs\PassengerTypeQuantity[]|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PassengerTypeQuantity[] $passengerTypeQuantity
     * @return \Sabre\TravelItineraryRead\Structs\AirItineraryPricingInfo
     */
    public function setPassengerTypeQuantity(array $passengerTypeQuantity = array())
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Add item to PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PassengerTypeQuantity $item
     * @return \Sabre\TravelItineraryRead\Structs\AirItineraryPricingInfo
     */
    public function addToPassengerTypeQuantity(\Sabre\TravelItineraryRead\Structs\PassengerTypeQuantity $item)
    {
        $this->PassengerTypeQuantity[] = $item;
        return $this;
    }
    /**
     * Get PrivateFareInformation value
     * @return \Sabre\TravelItineraryRead\Structs\PrivateFareInformation|null
     */
    public function getPrivateFareInformation()
    {
        return $this->PrivateFareInformation;
    }
    /**
     * Set PrivateFareInformation value
     * @param \Sabre\TravelItineraryRead\Structs\PrivateFareInformation $privateFareInformation
     * @return \Sabre\TravelItineraryRead\Structs\AirItineraryPricingInfo
     */
    public function setPrivateFareInformation(\Sabre\TravelItineraryRead\Structs\PrivateFareInformation $privateFareInformation = null)
    {
        $this->PrivateFareInformation = $privateFareInformation;
        return $this;
    }
    /**
     * Get PTC_FareBreakdown value
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown[]|null
     */
    public function getPTC_FareBreakdown()
    {
        return $this->PTC_FareBreakdown;
    }
    /**
     * Set PTC_FareBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown[] $pTC_FareBreakdown
     * @return \Sabre\TravelItineraryRead\Structs\AirItineraryPricingInfo
     */
    public function setPTC_FareBreakdown(array $pTC_FareBreakdown = array())
    {
        $this->PTC_FareBreakdown = $pTC_FareBreakdown;
        return $this;
    }
    /**
     * Add item to PTC_FareBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown $item
     * @return \Sabre\TravelItineraryRead\Structs\AirItineraryPricingInfo
     */
    public function addToPTC_FareBreakdown(\Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown $item)
    {
        $this->PTC_FareBreakdown[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AirItineraryPricingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
