<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType Structs
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The LocationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LocationType;
    /**
     * The AddressLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var string[]
     */
    public $AddressLine;
    /**
     * The CityName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The CityCodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CityCodes
     */
    public $CityCodes;
    /**
     * The LocalCityName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LocalCityName;
    /**
     * The StateProvince
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CodeDescriptionType
     */
    public $StateProvince;
    /**
     * The StateProvinceCodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\StateProvinceCodes
     */
    public $StateProvinceCodes;
    /**
     * The PostCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostCode;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CodeDescriptionType
     */
    public $Country;
    /**
     * The CountryCodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CountryCodes
     */
    public $CountryCodes;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Longitude;
    /**
     * The Altitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Altitude;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setLocationType()
     * @uses AddressType::setAddressLine()
     * @uses AddressType::setCityName()
     * @uses AddressType::setCityCodes()
     * @uses AddressType::setLocalCityName()
     * @uses AddressType::setStateProvince()
     * @uses AddressType::setStateProvinceCodes()
     * @uses AddressType::setPostCode()
     * @uses AddressType::setCountry()
     * @uses AddressType::setCountryCodes()
     * @uses AddressType::setLatitude()
     * @uses AddressType::setLongitude()
     * @uses AddressType::setAltitude()
     * @param string $locationType
     * @param string[] $addressLine
     * @param string $cityName
     * @param \Sabre\TravelItineraryRead\Structs\CityCodes $cityCodes
     * @param string $localCityName
     * @param \Sabre\TravelItineraryRead\Structs\CodeDescriptionType $stateProvince
     * @param \Sabre\TravelItineraryRead\Structs\StateProvinceCodes $stateProvinceCodes
     * @param string $postCode
     * @param \Sabre\TravelItineraryRead\Structs\CodeDescriptionType $country
     * @param \Sabre\TravelItineraryRead\Structs\CountryCodes $countryCodes
     * @param string $latitude
     * @param string $longitude
     * @param string $altitude
     */
    public function __construct($locationType = null, array $addressLine = array(), $cityName = null, \Sabre\TravelItineraryRead\Structs\CityCodes $cityCodes = null, $localCityName = null, \Sabre\TravelItineraryRead\Structs\CodeDescriptionType $stateProvince = null, \Sabre\TravelItineraryRead\Structs\StateProvinceCodes $stateProvinceCodes = null, $postCode = null, \Sabre\TravelItineraryRead\Structs\CodeDescriptionType $country = null, \Sabre\TravelItineraryRead\Structs\CountryCodes $countryCodes = null, $latitude = null, $longitude = null, $altitude = null)
    {
        $this
            ->setLocationType($locationType)
            ->setAddressLine($addressLine)
            ->setCityName($cityName)
            ->setCityCodes($cityCodes)
            ->setLocalCityName($localCityName)
            ->setStateProvince($stateProvince)
            ->setStateProvinceCodes($stateProvinceCodes)
            ->setPostCode($postCode)
            ->setCountry($country)
            ->setCountryCodes($countryCodes)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setAltitude($altitude);
    }
    /**
     * Get LocationType value
     * @return string|null
     */
    public function getLocationType()
    {
        return $this->LocationType;
    }
    /**
     * Set LocationType value
     * @param string $locationType
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setLocationType($locationType = null)
    {
        $this->LocationType = $locationType;
        return $this;
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setAddressLine(array $addressLine = array())
    {
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function addToAddressLine($item)
    {
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setCityName($cityName = null)
    {
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get CityCodes value
     * @return \Sabre\TravelItineraryRead\Structs\CityCodes|null
     */
    public function getCityCodes()
    {
        return $this->CityCodes;
    }
    /**
     * Set CityCodes value
     * @param \Sabre\TravelItineraryRead\Structs\CityCodes $cityCodes
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setCityCodes(\Sabre\TravelItineraryRead\Structs\CityCodes $cityCodes = null)
    {
        $this->CityCodes = $cityCodes;
        return $this;
    }
    /**
     * Get LocalCityName value
     * @return string|null
     */
    public function getLocalCityName()
    {
        return $this->LocalCityName;
    }
    /**
     * Set LocalCityName value
     * @param string $localCityName
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setLocalCityName($localCityName = null)
    {
        $this->LocalCityName = $localCityName;
        return $this;
    }
    /**
     * Get StateProvince value
     * @return \Sabre\TravelItineraryRead\Structs\CodeDescriptionType|null
     */
    public function getStateProvince()
    {
        return $this->StateProvince;
    }
    /**
     * Set StateProvince value
     * @param \Sabre\TravelItineraryRead\Structs\CodeDescriptionType $stateProvince
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setStateProvince(\Sabre\TravelItineraryRead\Structs\CodeDescriptionType $stateProvince = null)
    {
        $this->StateProvince = $stateProvince;
        return $this;
    }
    /**
     * Get StateProvinceCodes value
     * @return \Sabre\TravelItineraryRead\Structs\StateProvinceCodes|null
     */
    public function getStateProvinceCodes()
    {
        return $this->StateProvinceCodes;
    }
    /**
     * Set StateProvinceCodes value
     * @param \Sabre\TravelItineraryRead\Structs\StateProvinceCodes $stateProvinceCodes
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setStateProvinceCodes(\Sabre\TravelItineraryRead\Structs\StateProvinceCodes $stateProvinceCodes = null)
    {
        $this->StateProvinceCodes = $stateProvinceCodes;
        return $this;
    }
    /**
     * Get PostCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }
    /**
     * Set PostCode value
     * @param string $postCode
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setPostCode($postCode = null)
    {
        $this->PostCode = $postCode;
        return $this;
    }
    /**
     * Get Country value
     * @return \Sabre\TravelItineraryRead\Structs\CodeDescriptionType|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \Sabre\TravelItineraryRead\Structs\CodeDescriptionType $country
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setCountry(\Sabre\TravelItineraryRead\Structs\CodeDescriptionType $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryCodes value
     * @return \Sabre\TravelItineraryRead\Structs\CountryCodes|null
     */
    public function getCountryCodes()
    {
        return $this->CountryCodes;
    }
    /**
     * Set CountryCodes value
     * @param \Sabre\TravelItineraryRead\Structs\CountryCodes $countryCodes
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setCountryCodes(\Sabre\TravelItineraryRead\Structs\CountryCodes $countryCodes = null)
    {
        $this->CountryCodes = $countryCodes;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Altitude value
     * @return string|null
     */
    public function getAltitude()
    {
        return $this->Altitude;
    }
    /**
     * Set Altitude value
     * @param string $altitude
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public function setAltitude($altitude = null)
    {
        $this->Altitude = $altitude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
