<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher Structs
 * @subpackage Structs
 */
class Voucher extends AbstractStructBase
{
    /**
     * The billingNumber
     * Meta informations extracted from the WSDL
     * - documentation: "billingNumber" used to return the voucher billing number associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $billingNumber;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - documentation: "format" is used to return the voucher format associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $format;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: "id" is used to return the voucher ID associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $id;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: "type" is used to return the type of voucher associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * The BillingNumber
     * Meta informations extracted from the WSDL
     * - documentation: "BillingNumber" used to return the voucher billing number associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $BillingNumber;
    /**
     * The Format
     * Meta informations extracted from the WSDL
     * - documentation: "Format" is used to return the voucher format associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $Format;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: "ID" is used to return the voucher ID associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the type of voucher associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setBillingNumber()
     * @uses Voucher::setFormat()
     * @uses Voucher::setId()
     * @uses Voucher::setType()
     * @uses Voucher::setBillingNumber_1()
     * @uses Voucher::setFormat_1()
     * @uses Voucher::setID_1()
     * @uses Voucher::setType_1()
     * @param string $billingNumber
     * @param string $format
     * @param string $id
     * @param string $type
     * @param string $billingNumber
     * @param string $format
     * @param string $iD
     * @param string $type
     */
    public function __construct($billingNumber = null, $format = null, $id = null, $type = null, $billingNumber = null, $format = null, $iD = null, $type = null)
    {
        $this
            ->setBillingNumber($billingNumber)
            ->setFormat($format)
            ->setId($id)
            ->setType($type)
            ->setBillingNumber_1($billingNumber)
            ->setFormat_1($format)
            ->setID_1($iD)
            ->setType_1($type);
    }
    /**
     * Get BillingNumber value
     * @return string|null
     */
    public function getBillingNumber()
    {
        return $this->billingNumber;
    }
    /**
     * Set BillingNumber value
     * @param string $billingNumber
     * @return \Sabre\TravelItineraryRead\Structs\Voucher
     */
    public function setBillingNumber($billingNumber = null)
    {
        $this->billingNumber = $billingNumber;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \Sabre\TravelItineraryRead\Structs\Voucher
     */
    public function setFormat($format = null)
    {
        $this->format = $format;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Voucher
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Voucher
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get billingNumber_1 value
     * @return billingNumber_1
     */
    public function getBillingNumber_1()
    {
        return $this->BillingNumber;
    }
    /**
     * Set BillingNumber value
     * @param string $billingNumber
     * @return \Sabre\TravelItineraryRead\Structs\Voucher
     */
    public function setBillingNumber_1($billingNumber = null)
    {
        $this->BillingNumber = $billingNumber;
        return $this;
    }
    /**
     * Get format_1 value
     * @return format_1
     */
    public function getFormat_1()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \Sabre\TravelItineraryRead\Structs\Voucher
     */
    public function setFormat_1($format = null)
    {
        $this->Format = $format;
        return $this;
    }
    /**
     * Get iD_1 value
     * @return iD_1
     */
    public function getID_1()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Sabre\TravelItineraryRead\Structs\Voucher
     */
    public function setID_1($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get type_1 value
     * @return type_1
     */
    public function getType_1()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Voucher
     */
    public function setType_1($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Voucher
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
