<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vendor Structs
 * Meta informations extracted from the WSDL
 * - documentation: Visa vendor
 * @subpackage Structs
 */
class Vendor extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Vendor name
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Ski vendor code | "Code" is used to return the vendor code associated with the particular insurance segment. | "code" is used to return the vehicle vendor code.
     * - use: optional
     * @var string
     */
    public $code;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Ski vendor name
     * @var string
     */
    public $name;
    /**
     * The companyShortName
     * Meta informations extracted from the WSDL
     * - documentation: "CompanyShortName" is used to return the vendor's name associated with the particular insurance segment. | "companyShortName" is used to return the company name associated with the particular vehicle vendor code.
     * - use: optional
     * @var string
     */
    public $companyShortName;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return the vendor code associated with the particular segment. | "Code" is used to return the vendor code associated with the particular cruise segment. | "Code" is used to return the vendor code associated with the
     * particular insurance segment. | "Code" is used to return the vendor code associated with the particular segment. | "Code" is used to return the vendor code associated with the particular rail segment. | "Code" is used to return the vendor code
     * associated with the particular segment. | "Code" is used to return the vehicle vendor code.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The CompanyShortName
     * Meta informations extracted from the WSDL
     * - documentation: "CompanyShortName" is used to return the vendor's name associated with the particular insurance segment. | "CompanyShortName" is used to return the company name associated with the particular vehicle vendor code.
     * - use: optional
     * @var string
     */
    public $CompanyShortName;
    /**
     * Constructor method for Vendor
     * @uses Vendor::setName()
     * @uses Vendor::setCode()
     * @uses Vendor::setName_1()
     * @uses Vendor::setCompanyShortName()
     * @uses Vendor::setCode_1()
     * @uses Vendor::setCompanyShortName_1()
     * @param string $name
     * @param string $code
     * @param string $name
     * @param string $companyShortName
     * @param string $code
     * @param string $companyShortName
     */
    public function __construct($name = null, $code = null, $name = null, $companyShortName = null, $code = null, $companyShortName = null)
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setName_1($name)
            ->setCompanyShortName($companyShortName)
            ->setCode_1($code)
            ->setCompanyShortName_1($companyShortName);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get name_1 value
     * @return name_1
     */
    public function getName_1()
    {
        return $this->name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public function setName_1($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get CompanyShortName value
     * @return string|null
     */
    public function getCompanyShortName()
    {
        return $this->companyShortName;
    }
    /**
     * Set CompanyShortName value
     * @param string $companyShortName
     * @return \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public function setCompanyShortName($companyShortName = null)
    {
        $this->companyShortName = $companyShortName;
        return $this;
    }
    /**
     * Get code_1 value
     * @return code_1
     */
    public function getCode_1()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public function setCode_1($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get companyShortName_1 value
     * @return companyShortName_1
     */
    public function getCompanyShortName_1()
    {
        return $this->CompanyShortName;
    }
    /**
     * Set CompanyShortName value
     * @param string $companyShortName
     * @return \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public function setCompanyShortName_1($companyShortName = null)
    {
        $this->CompanyShortName = $companyShortName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
