<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Traveler Structs
 * @subpackage Structs
 */
class Traveler extends PassengerType
{
    /**
     * The CoverAddOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\InsuranceCoverAddOn[]
     */
    public $CoverAddOn;
    /**
     * The treatAsAdult
     * @var bool
     */
    public $treatAsAdult;
    /**
     * Constructor method for Traveler
     * @uses Traveler::setCoverAddOn()
     * @uses Traveler::setTreatAsAdult()
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceCoverAddOn[] $coverAddOn
     * @param bool $treatAsAdult
     */
    public function __construct(array $coverAddOn = array(), $treatAsAdult = null)
    {
        $this
            ->setCoverAddOn($coverAddOn)
            ->setTreatAsAdult($treatAsAdult);
    }
    /**
     * Get CoverAddOn value
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceCoverAddOn[]|null
     */
    public function getCoverAddOn()
    {
        return $this->CoverAddOn;
    }
    /**
     * Set CoverAddOn value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceCoverAddOn[] $coverAddOn
     * @return \Sabre\TravelItineraryRead\Structs\Traveler
     */
    public function setCoverAddOn(array $coverAddOn = array())
    {
        $this->CoverAddOn = $coverAddOn;
        return $this;
    }
    /**
     * Add item to CoverAddOn value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceCoverAddOn $item
     * @return \Sabre\TravelItineraryRead\Structs\Traveler
     */
    public function addToCoverAddOn(\Sabre\TravelItineraryRead\Structs\InsuranceCoverAddOn $item)
    {
        $this->CoverAddOn[] = $item;
        return $this;
    }
    /**
     * Get treatAsAdult value
     * @return bool|null
     */
    public function getTreatAsAdult()
    {
        return $this->treatAsAdult;
    }
    /**
     * Set treatAsAdult value
     * @param bool $treatAsAdult
     * @return \Sabre\TravelItineraryRead\Structs\Traveler
     */
    public function setTreatAsAdult($treatAsAdult = null)
    {
        $this->treatAsAdult = $treatAsAdult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Traveler
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
