<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelItinerary Structs
 * @subpackage Structs
 */
class TravelItinerary extends AbstractStructBase
{
    /**
     * The AccountingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AccountingInfo[]
     */
    public $AccountingInfo;
    /**
     * The CustomerInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CustomerInfo
     */
    public $CustomerInfo;
    /**
     * The FileInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FileInfo
     */
    public $FileInfo;
    /**
     * The ItineraryInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ItineraryInfo
     */
    public $ItineraryInfo;
    /**
     * The ItineraryRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ItineraryRef
     */
    public $ItineraryRef;
    /**
     * The PayInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PayInfo[]
     */
    public $PayInfo;
    /**
     * The QueueInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\QueueInfo
     */
    public $QueueInfo;
    /**
     * The RemarkInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\RemarkInfo
     */
    public $RemarkInfo;
    /**
     * The SpecialServiceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SpecialServiceInfo[]
     */
    public $SpecialServiceInfo;
    /**
     * The OpenReservationElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\OpenReservationElements
     */
    public $OpenReservationElements;
    /**
     * The CorporateIDInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CorporateIDInfo[]
     */
    public $CorporateIDInfo;
    /**
     * The AssociationMatrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AssociationMatrices
     */
    public $AssociationMatrices;
    /**
     * Constructor method for TravelItinerary
     * @uses TravelItinerary::setAccountingInfo()
     * @uses TravelItinerary::setCustomerInfo()
     * @uses TravelItinerary::setFileInfo()
     * @uses TravelItinerary::setItineraryInfo()
     * @uses TravelItinerary::setItineraryRef()
     * @uses TravelItinerary::setPayInfo()
     * @uses TravelItinerary::setQueueInfo()
     * @uses TravelItinerary::setRemarkInfo()
     * @uses TravelItinerary::setSpecialServiceInfo()
     * @uses TravelItinerary::setOpenReservationElements()
     * @uses TravelItinerary::setCorporateIDInfo()
     * @uses TravelItinerary::setAssociationMatrices()
     * @param \Sabre\TravelItineraryRead\Structs\AccountingInfo[] $accountingInfo
     * @param \Sabre\TravelItineraryRead\Structs\CustomerInfo $customerInfo
     * @param \Sabre\TravelItineraryRead\Structs\FileInfo $fileInfo
     * @param \Sabre\TravelItineraryRead\Structs\ItineraryInfo $itineraryInfo
     * @param \Sabre\TravelItineraryRead\Structs\ItineraryRef $itineraryRef
     * @param \Sabre\TravelItineraryRead\Structs\PayInfo[] $payInfo
     * @param \Sabre\TravelItineraryRead\Structs\QueueInfo $queueInfo
     * @param \Sabre\TravelItineraryRead\Structs\RemarkInfo $remarkInfo
     * @param \Sabre\TravelItineraryRead\Structs\SpecialServiceInfo[] $specialServiceInfo
     * @param \Sabre\TravelItineraryRead\Structs\OpenReservationElements $openReservationElements
     * @param \Sabre\TravelItineraryRead\Structs\CorporateIDInfo[] $corporateIDInfo
     * @param \Sabre\TravelItineraryRead\Structs\AssociationMatrices $associationMatrices
     */
    public function __construct(array $accountingInfo = array(), \Sabre\TravelItineraryRead\Structs\CustomerInfo $customerInfo = null, \Sabre\TravelItineraryRead\Structs\FileInfo $fileInfo = null, \Sabre\TravelItineraryRead\Structs\ItineraryInfo $itineraryInfo = null, \Sabre\TravelItineraryRead\Structs\ItineraryRef $itineraryRef = null, array $payInfo = array(), \Sabre\TravelItineraryRead\Structs\QueueInfo $queueInfo = null, \Sabre\TravelItineraryRead\Structs\RemarkInfo $remarkInfo = null, array $specialServiceInfo = array(), \Sabre\TravelItineraryRead\Structs\OpenReservationElements $openReservationElements = null, array $corporateIDInfo = array(), \Sabre\TravelItineraryRead\Structs\AssociationMatrices $associationMatrices = null)
    {
        $this
            ->setAccountingInfo($accountingInfo)
            ->setCustomerInfo($customerInfo)
            ->setFileInfo($fileInfo)
            ->setItineraryInfo($itineraryInfo)
            ->setItineraryRef($itineraryRef)
            ->setPayInfo($payInfo)
            ->setQueueInfo($queueInfo)
            ->setRemarkInfo($remarkInfo)
            ->setSpecialServiceInfo($specialServiceInfo)
            ->setOpenReservationElements($openReservationElements)
            ->setCorporateIDInfo($corporateIDInfo)
            ->setAssociationMatrices($associationMatrices);
    }
    /**
     * Get AccountingInfo value
     * @return \Sabre\TravelItineraryRead\Structs\AccountingInfo[]|null
     */
    public function getAccountingInfo()
    {
        return $this->AccountingInfo;
    }
    /**
     * Set AccountingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AccountingInfo[] $accountingInfo
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setAccountingInfo(array $accountingInfo = array())
    {
        $this->AccountingInfo = $accountingInfo;
        return $this;
    }
    /**
     * Add item to AccountingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AccountingInfo $item
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function addToAccountingInfo(\Sabre\TravelItineraryRead\Structs\AccountingInfo $item)
    {
        $this->AccountingInfo[] = $item;
        return $this;
    }
    /**
     * Get CustomerInfo value
     * @return \Sabre\TravelItineraryRead\Structs\CustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return $this->CustomerInfo;
    }
    /**
     * Set CustomerInfo value
     * @param \Sabre\TravelItineraryRead\Structs\CustomerInfo $customerInfo
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setCustomerInfo(\Sabre\TravelItineraryRead\Structs\CustomerInfo $customerInfo = null)
    {
        $this->CustomerInfo = $customerInfo;
        return $this;
    }
    /**
     * Get FileInfo value
     * @return \Sabre\TravelItineraryRead\Structs\FileInfo|null
     */
    public function getFileInfo()
    {
        return $this->FileInfo;
    }
    /**
     * Set FileInfo value
     * @param \Sabre\TravelItineraryRead\Structs\FileInfo $fileInfo
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setFileInfo(\Sabre\TravelItineraryRead\Structs\FileInfo $fileInfo = null)
    {
        $this->FileInfo = $fileInfo;
        return $this;
    }
    /**
     * Get ItineraryInfo value
     * @return \Sabre\TravelItineraryRead\Structs\ItineraryInfo|null
     */
    public function getItineraryInfo()
    {
        return $this->ItineraryInfo;
    }
    /**
     * Set ItineraryInfo value
     * @param \Sabre\TravelItineraryRead\Structs\ItineraryInfo $itineraryInfo
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setItineraryInfo(\Sabre\TravelItineraryRead\Structs\ItineraryInfo $itineraryInfo = null)
    {
        $this->ItineraryInfo = $itineraryInfo;
        return $this;
    }
    /**
     * Get ItineraryRef value
     * @return \Sabre\TravelItineraryRead\Structs\ItineraryRef|null
     */
    public function getItineraryRef()
    {
        return $this->ItineraryRef;
    }
    /**
     * Set ItineraryRef value
     * @param \Sabre\TravelItineraryRead\Structs\ItineraryRef $itineraryRef
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setItineraryRef(\Sabre\TravelItineraryRead\Structs\ItineraryRef $itineraryRef = null)
    {
        $this->ItineraryRef = $itineraryRef;
        return $this;
    }
    /**
     * Get PayInfo value
     * @return \Sabre\TravelItineraryRead\Structs\PayInfo[]|null
     */
    public function getPayInfo()
    {
        return $this->PayInfo;
    }
    /**
     * Set PayInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PayInfo[] $payInfo
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setPayInfo(array $payInfo = array())
    {
        $this->PayInfo = $payInfo;
        return $this;
    }
    /**
     * Add item to PayInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PayInfo $item
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function addToPayInfo(\Sabre\TravelItineraryRead\Structs\PayInfo $item)
    {
        $this->PayInfo[] = $item;
        return $this;
    }
    /**
     * Get QueueInfo value
     * @return \Sabre\TravelItineraryRead\Structs\QueueInfo|null
     */
    public function getQueueInfo()
    {
        return $this->QueueInfo;
    }
    /**
     * Set QueueInfo value
     * @param \Sabre\TravelItineraryRead\Structs\QueueInfo $queueInfo
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setQueueInfo(\Sabre\TravelItineraryRead\Structs\QueueInfo $queueInfo = null)
    {
        $this->QueueInfo = $queueInfo;
        return $this;
    }
    /**
     * Get RemarkInfo value
     * @return \Sabre\TravelItineraryRead\Structs\RemarkInfo|null
     */
    public function getRemarkInfo()
    {
        return $this->RemarkInfo;
    }
    /**
     * Set RemarkInfo value
     * @param \Sabre\TravelItineraryRead\Structs\RemarkInfo $remarkInfo
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setRemarkInfo(\Sabre\TravelItineraryRead\Structs\RemarkInfo $remarkInfo = null)
    {
        $this->RemarkInfo = $remarkInfo;
        return $this;
    }
    /**
     * Get SpecialServiceInfo value
     * @return \Sabre\TravelItineraryRead\Structs\SpecialServiceInfo[]|null
     */
    public function getSpecialServiceInfo()
    {
        return $this->SpecialServiceInfo;
    }
    /**
     * Set SpecialServiceInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\SpecialServiceInfo[] $specialServiceInfo
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setSpecialServiceInfo(array $specialServiceInfo = array())
    {
        $this->SpecialServiceInfo = $specialServiceInfo;
        return $this;
    }
    /**
     * Add item to SpecialServiceInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\SpecialServiceInfo $item
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function addToSpecialServiceInfo(\Sabre\TravelItineraryRead\Structs\SpecialServiceInfo $item)
    {
        $this->SpecialServiceInfo[] = $item;
        return $this;
    }
    /**
     * Get OpenReservationElements value
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElements|null
     */
    public function getOpenReservationElements()
    {
        return $this->OpenReservationElements;
    }
    /**
     * Set OpenReservationElements value
     * @param \Sabre\TravelItineraryRead\Structs\OpenReservationElements $openReservationElements
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setOpenReservationElements(\Sabre\TravelItineraryRead\Structs\OpenReservationElements $openReservationElements = null)
    {
        $this->OpenReservationElements = $openReservationElements;
        return $this;
    }
    /**
     * Get CorporateIDInfo value
     * @return \Sabre\TravelItineraryRead\Structs\CorporateIDInfo[]|null
     */
    public function getCorporateIDInfo()
    {
        return $this->CorporateIDInfo;
    }
    /**
     * Set CorporateIDInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\CorporateIDInfo[] $corporateIDInfo
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setCorporateIDInfo(array $corporateIDInfo = array())
    {
        $this->CorporateIDInfo = $corporateIDInfo;
        return $this;
    }
    /**
     * Add item to CorporateIDInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\CorporateIDInfo $item
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function addToCorporateIDInfo(\Sabre\TravelItineraryRead\Structs\CorporateIDInfo $item)
    {
        $this->CorporateIDInfo[] = $item;
        return $this;
    }
    /**
     * Get AssociationMatrices value
     * @return \Sabre\TravelItineraryRead\Structs\AssociationMatrices|null
     */
    public function getAssociationMatrices()
    {
        return $this->AssociationMatrices;
    }
    /**
     * Set AssociationMatrices value
     * @param \Sabre\TravelItineraryRead\Structs\AssociationMatrices $associationMatrices
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public function setAssociationMatrices(\Sabre\TravelItineraryRead\Structs\AssociationMatrices $associationMatrices = null)
    {
        $this->AssociationMatrices = $associationMatrices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\TravelItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
