<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Total Structs
 * Meta informations extracted from the WSDL
 * - documentation: Total payment after discount
 * @subpackage Structs
 */
class Total extends AbstractStructBase
{
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - documentation: Payment due date | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DueDate;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Amount to pay
     * @var float
     */
    public $amount;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - documentation: Currency
     * @var string
     */
    public $currency;
    /**
     * Constructor method for Total
     * @uses Total::setDueDate()
     * @uses Total::setAmount()
     * @uses Total::setCurrency()
     * @param string $dueDate
     * @param float $amount
     * @param string $currency
     */
    public function __construct($dueDate = null, $amount = null, $currency = null)
    {
        $this
            ->setDueDate($dueDate)
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get DueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \Sabre\TravelItineraryRead\Structs\Total
     */
    public function setDueDate($dueDate = null)
    {
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \Sabre\TravelItineraryRead\Structs\Total
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \Sabre\TravelItineraryRead\Structs\Total
     */
    public function setCurrency($currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Total
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
