<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Surface Structs
 * @subpackage Structs
 */
class Surface extends AbstractStructBase
{
    /**
     * The ArrivalDepartureIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: "ArrivalDepartureIdentifier" is used to return the arrival/departure indicator associated with the particular segment.
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalDepartureIdentifier;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FlightSegment
     */
    public $FlightSegment;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: "POS" is used to return the point of sale location associated with the particular segment.
     * - minOccurs: 0
     * @var string
     */
    public $POS;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous free text associated with the particular segment.
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public $Vendor;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: "Id" is used to return the id of Surface (BasData)
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "DepartureDateTime" is used to return the date and time associated with the particular tour reservation. | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - documentation: "NumberInParty" is used to return the number of passengers associated with the particular tour reservation.
     * - use: optional
     * @var string
     */
    public $NumberInParty;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the segment type.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: It returns information if current segment is past or not. Attribute is populated based on Surface - @DepartureDateTime, Surface - OriginLocation - @LocationCode. There is no end date, thus it will be calculated like air segment.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * Constructor method for Surface
     * @uses Surface::setArrivalDepartureIdentifier()
     * @uses Surface::setFlightSegment()
     * @uses Surface::setOriginLocation()
     * @uses Surface::setPOS()
     * @uses Surface::setText()
     * @uses Surface::setVendor()
     * @uses Surface::setId()
     * @uses Surface::setDepartureDateTime()
     * @uses Surface::setNumberInParty()
     * @uses Surface::setSegmentNumber()
     * @uses Surface::setStatus()
     * @uses Surface::setType()
     * @uses Surface::setIsPast()
     * @param string $arrivalDepartureIdentifier
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment $flightSegment
     * @param \Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation
     * @param string $pOS
     * @param string $text
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @param string $id
     * @param string $departureDateTime
     * @param string $numberInParty
     * @param string $segmentNumber
     * @param string $status
     * @param string $type
     * @param bool $isPast
     */
    public function __construct($arrivalDepartureIdentifier = null, \Sabre\TravelItineraryRead\Structs\FlightSegment $flightSegment = null, \Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation = null, $pOS = null, $text = null, \Sabre\TravelItineraryRead\Structs\Vendor $vendor = null, $id = null, $departureDateTime = null, $numberInParty = null, $segmentNumber = null, $status = null, $type = null, $isPast = null)
    {
        $this
            ->setArrivalDepartureIdentifier($arrivalDepartureIdentifier)
            ->setFlightSegment($flightSegment)
            ->setOriginLocation($originLocation)
            ->setPOS($pOS)
            ->setText($text)
            ->setVendor($vendor)
            ->setId($id)
            ->setDepartureDateTime($departureDateTime)
            ->setNumberInParty($numberInParty)
            ->setSegmentNumber($segmentNumber)
            ->setStatus($status)
            ->setType($type)
            ->setIsPast($isPast);
    }
    /**
     * Get ArrivalDepartureIdentifier value
     * @return string|null
     */
    public function getArrivalDepartureIdentifier()
    {
        return $this->ArrivalDepartureIdentifier;
    }
    /**
     * Set ArrivalDepartureIdentifier value
     * @param string $arrivalDepartureIdentifier
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setArrivalDepartureIdentifier($arrivalDepartureIdentifier = null)
    {
        $this->ArrivalDepartureIdentifier = $arrivalDepartureIdentifier;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\TravelItineraryRead\Structs\FlightSegment|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment $flightSegment
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setFlightSegment(\Sabre\TravelItineraryRead\Structs\FlightSegment $flightSegment = null)
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\TravelItineraryRead\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setOriginLocation(\Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get POS value
     * @return string|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param string $pOS
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setPOS($pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\TravelItineraryRead\Structs\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setVendor(\Sabre\TravelItineraryRead\Structs\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return string|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param string $numberInParty
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Surface
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
