<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service Structs
 * Meta informations extracted from the WSDL
 * - type: Service
 * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
 * - maxLength: 128
 * - minLength: 1
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Airline
     */
    public $Airline;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous SSR-related free text if applicable
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The SSR_Code
     * Meta informations extracted from the WSDL
     * - documentation: "SSR_Code is used to return the SSR code associated with the particular SSR segment
     * - use: optional
     * @var string
     */
    public $SSR_Code;
    /**
     * The SSR_Type
     * Meta informations extracted from the WSDL
     * - documentation: "SSR_Type" is used to return the SSR type associated with the particular SSR segment Example: WCHR
     * - use: optional
     * @var string
     */
    public $SSR_Type;
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $type;
    /**
     * The operation
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $operation;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Short - A field of text characters and no other constraints.
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * The ttl
     * @var int
     */
    public $ttl;
    /**
     * Constructor method for Service
     * @uses Service::setAirline()
     * @uses Service::setPersonName()
     * @uses Service::setText()
     * @uses Service::setSSR_Code()
     * @uses Service::setSSR_Type()
     * @uses Service::set_()
     * @uses Service::setType()
     * @uses Service::setOperation()
     * @uses Service::setVersion()
     * @uses Service::setTtl()
     * @param \Sabre\TravelItineraryRead\Structs\Airline $airline
     * @param \Sabre\TravelItineraryRead\Structs\PersonName[] $personName
     * @param string[] $text
     * @param string $sSR_Code
     * @param string $sSR_Type
     * @param string $_
     * @param string $type
     * @param string $operation
     * @param string $version
     * @param int $ttl
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\Airline $airline = null, array $personName = array(), array $text = array(), $sSR_Code = null, $sSR_Type = null, $_ = null, $type = null, $operation = null, $version = null, $ttl = null)
    {
        $this
            ->setAirline($airline)
            ->setPersonName($personName)
            ->setText($text)
            ->setSSR_Code($sSR_Code)
            ->setSSR_Type($sSR_Type)
            ->set_($_)
            ->setType($type)
            ->setOperation($operation)
            ->setVersion($version)
            ->setTtl($ttl);
    }
    /**
     * Get Airline value
     * @return \Sabre\TravelItineraryRead\Structs\Airline|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \Sabre\TravelItineraryRead\Structs\Airline $airline
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function setAirline(\Sabre\TravelItineraryRead\Structs\Airline $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\TravelItineraryRead\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PersonName[] $personName
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PersonName $item
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function addToPersonName(\Sabre\TravelItineraryRead\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get SSR_Code value
     * @return string|null
     */
    public function getSSR_Code()
    {
        return $this->SSR_Code;
    }
    /**
     * Set SSR_Code value
     * @param string $sSR_Code
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function setSSR_Code($sSR_Code = null)
    {
        $this->SSR_Code = $sSR_Code;
        return $this;
    }
    /**
     * Get SSR_Type value
     * @return string|null
     */
    public function getSSR_Type()
    {
        return $this->SSR_Type;
    }
    /**
     * Set SSR_Type value
     * @param string $sSR_Type
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function setSSR_Type($sSR_Type = null)
    {
        $this->SSR_Type = $sSR_Type;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->operation;
    }
    /**
     * Set operation value
     * @param string $operation
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function setOperation($operation = null)
    {
        $this->operation = $operation;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get ttl value
     * @return int|null
     */
    public function getTtl()
    {
        return $this->ttl;
    }
    /**
     * Set ttl value
     * @param int $ttl
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public function setTtl($ttl = null)
    {
        $this->ttl = $ttl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
