<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentData Structs
 * @subpackage Structs
 */
class SegmentData extends AbstractStructBase
{
    /**
     * The FareComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public $FareComponent;
    /**
     * The Segments
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion[]
     */
    public $Segments;
    /**
     * Constructor method for SegmentData
     * @uses SegmentData::setFareComponent()
     * @uses SegmentData::setSegments()
     * @param \Sabre\TravelItineraryRead\Structs\FareComponent $fareComponent
     * @param \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion[] $segments
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\FareComponent $fareComponent = null, array $segments = array())
    {
        $this
            ->setFareComponent($fareComponent)
            ->setSegments($segments);
    }
    /**
     * Get FareComponent value
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * Set FareComponent value
     * @param \Sabre\TravelItineraryRead\Structs\FareComponent $fareComponent
     * @return \Sabre\TravelItineraryRead\Structs\SegmentData
     */
    public function setFareComponent(\Sabre\TravelItineraryRead\Structs\FareComponent $fareComponent = null)
    {
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Get Segments value
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion[]|null
     */
    public function getSegments()
    {
        return $this->Segments;
    }
    /**
     * Set Segments value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion[] $segments
     * @return \Sabre\TravelItineraryRead\Structs\SegmentData
     */
    public function setSegments(array $segments = array())
    {
        $this->Segments = $segments;
        return $this;
    }
    /**
     * Add item to Segments value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion $item
     * @return \Sabre\TravelItineraryRead\Structs\SegmentData
     */
    public function addToSegments(\Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion $item)
    {
        $this->Segments[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\SegmentData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
