<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Segment Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Segment" element is used as a container for segment, assiociated with particular ancillary service, details.
 * @subpackage Structs
 */
class Segment extends AbstractStructBase
{
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AirlineCode;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FlightNumber;
    /**
     * The ClassOfService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClassOfService;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DepartureDate;
    /**
     * The BoardPoint
     * Meta informations extracted from the WSDL
     * - documentation: "BoardPoint" indicates departure city.
     * - minOccurs: 0
     * @var string
     */
    public $BoardPoint;
    /**
     * The OffPoint
     * Meta informations extracted from the WSDL
     * - documentation: "OffPoint" indicates arrival city.
     * - minOccurs: 0
     * @var string
     */
    public $OffPoint;
    /**
     * The EquipmentType
     * Meta informations extracted from the WSDL
     * - documentation: "EquipmetType" indicates aircraft type used for the flight as per IATA standard.
     * - minOccurs: 0
     * @var string
     */
    public $EquipmentType;
    /**
     * The ETicketNumber
     * Meta informations extracted from the WSDL
     * - documentation: "ETicketNumber" returns the ETicketNumber
     * - minOccurs: 0
     * @var string
     */
    public $ETicketNumber;
    /**
     * The ETicketCoupon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ETicketCoupon;
    /**
     * The EMDNumber
     * Meta informations extracted from the WSDL
     * - documentation: "EMDNumber" returns the EMD Number issued for the service
     * - minOccurs: 0
     * @var string
     */
    public $EMDNumber;
    /**
     * The EMDCoupon
     * Meta informations extracted from the WSDL
     * - documentation: "EMDCoupon" is used to identify EMD coupon details for the service .
     * - minOccurs: 0
     * @var string
     */
    public $EMDCoupon;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $id;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $sequence;
    /**
     * Constructor method for Segment
     * @uses Segment::setAirlineCode()
     * @uses Segment::setFlightNumber()
     * @uses Segment::setClassOfService()
     * @uses Segment::setDepartureDate()
     * @uses Segment::setBoardPoint()
     * @uses Segment::setOffPoint()
     * @uses Segment::setEquipmentType()
     * @uses Segment::setETicketNumber()
     * @uses Segment::setETicketCoupon()
     * @uses Segment::setEMDNumber()
     * @uses Segment::setEMDCoupon()
     * @uses Segment::setId()
     * @uses Segment::setSequence()
     * @param string $airlineCode
     * @param string $flightNumber
     * @param string $classOfService
     * @param string $departureDate
     * @param string $boardPoint
     * @param string $offPoint
     * @param string $equipmentType
     * @param string $eTicketNumber
     * @param string $eTicketCoupon
     * @param string $eMDNumber
     * @param string $eMDCoupon
     * @param string $id
     * @param string $sequence
     */
    public function __construct($airlineCode = null, $flightNumber = null, $classOfService = null, $departureDate = null, $boardPoint = null, $offPoint = null, $equipmentType = null, $eTicketNumber = null, $eTicketCoupon = null, $eMDNumber = null, $eMDCoupon = null, $id = null, $sequence = null)
    {
        $this
            ->setAirlineCode($airlineCode)
            ->setFlightNumber($flightNumber)
            ->setClassOfService($classOfService)
            ->setDepartureDate($departureDate)
            ->setBoardPoint($boardPoint)
            ->setOffPoint($offPoint)
            ->setEquipmentType($equipmentType)
            ->setETicketNumber($eTicketNumber)
            ->setETicketCoupon($eTicketCoupon)
            ->setEMDNumber($eMDNumber)
            ->setEMDCoupon($eMDCoupon)
            ->setId($id)
            ->setSequence($sequence);
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return string|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param string $classOfService
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setClassOfService($classOfService = null)
    {
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get BoardPoint value
     * @return string|null
     */
    public function getBoardPoint()
    {
        return $this->BoardPoint;
    }
    /**
     * Set BoardPoint value
     * @param string $boardPoint
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setBoardPoint($boardPoint = null)
    {
        $this->BoardPoint = $boardPoint;
        return $this;
    }
    /**
     * Get OffPoint value
     * @return string|null
     */
    public function getOffPoint()
    {
        return $this->OffPoint;
    }
    /**
     * Set OffPoint value
     * @param string $offPoint
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setOffPoint($offPoint = null)
    {
        $this->OffPoint = $offPoint;
        return $this;
    }
    /**
     * Get EquipmentType value
     * @return string|null
     */
    public function getEquipmentType()
    {
        return $this->EquipmentType;
    }
    /**
     * Set EquipmentType value
     * @param string $equipmentType
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setEquipmentType($equipmentType = null)
    {
        $this->EquipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get ETicketNumber value
     * @return string|null
     */
    public function getETicketNumber()
    {
        return $this->ETicketNumber;
    }
    /**
     * Set ETicketNumber value
     * @param string $eTicketNumber
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        $this->ETicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get ETicketCoupon value
     * @return string|null
     */
    public function getETicketCoupon()
    {
        return $this->ETicketCoupon;
    }
    /**
     * Set ETicketCoupon value
     * @param string $eTicketCoupon
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setETicketCoupon($eTicketCoupon = null)
    {
        $this->ETicketCoupon = $eTicketCoupon;
        return $this;
    }
    /**
     * Get EMDNumber value
     * @return string|null
     */
    public function getEMDNumber()
    {
        return $this->EMDNumber;
    }
    /**
     * Set EMDNumber value
     * @param string $eMDNumber
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setEMDNumber($eMDNumber = null)
    {
        $this->EMDNumber = $eMDNumber;
        return $this;
    }
    /**
     * Get EMDCoupon value
     * @return string|null
     */
    public function getEMDCoupon()
    {
        return $this->EMDCoupon;
    }
    /**
     * Set EMDCoupon value
     * @param string $eMDCoupon
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setEMDCoupon($eMDCoupon = null)
    {
        $this->EMDCoupon = $eMDCoupon;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get sequence value
     * @return string|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param string $sequence
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Segment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
