<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: Holds Queue placement details
 * @subpackage Structs
 */
class QueueInfo extends AbstractStructBase
{
    /**
     * The Placement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Placement[]
     */
    public $Placement;
    /**
     * Constructor method for QueueInfo
     * @uses QueueInfo::setPlacement()
     * @param \Sabre\TravelItineraryRead\Structs\Placement[] $placement
     */
    public function __construct(array $placement = array())
    {
        $this
            ->setPlacement($placement);
    }
    /**
     * Get Placement value
     * @return \Sabre\TravelItineraryRead\Structs\Placement[]|null
     */
    public function getPlacement()
    {
        return $this->Placement;
    }
    /**
     * Set Placement value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Placement[] $placement
     * @return \Sabre\TravelItineraryRead\Structs\QueueInfo
     */
    public function setPlacement(array $placement = array())
    {
        $this->Placement = $placement;
        return $this;
    }
    /**
     * Add item to Placement value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Placement $item
     * @return \Sabre\TravelItineraryRead\Structs\QueueInfo
     */
    public function addToPlacement(\Sabre\TravelItineraryRead\Structs\Placement $item)
    {
        $this->Placement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\QueueInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
