<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedEquipment Structs
 * @subpackage Structs
 */
class PricedEquipment extends AbstractStructBase
{
    /**
     * The equipmentType
     * Meta informations extracted from the WSDL
     * - documentation: "equipType" is used to return the category of vehicle associated with the vehicle rental.
     * - use: optional
     * @var string
     */
    public $equipmentType;
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - documentation: "quantity" is used to return the number of reserved vehicles associated with the vehicle rental.
     * - use: optional
     * @var string
     */
    public $quantity;
    /**
     * The specialEquipment
     * Meta informations extracted from the WSDL
     * - documentation: "specialEquip" is used to return special equipment-related information.
     * - use: optional
     * @var string
     */
    public $specialEquipment;
    /**
     * The specialEquipmentConfirmed
     * Meta informations extracted from the WSDL
     * - documentation: "specialEquipConfirmed" is used to denote whether or not the special equipment is confirmed.
     * - use: optional
     * @var string
     */
    public $specialEquipmentConfirmed;
    /**
     * Constructor method for PricedEquipment
     * @uses PricedEquipment::setEquipmentType()
     * @uses PricedEquipment::setQuantity()
     * @uses PricedEquipment::setSpecialEquipment()
     * @uses PricedEquipment::setSpecialEquipmentConfirmed()
     * @param string $equipmentType
     * @param string $quantity
     * @param string $specialEquipment
     * @param string $specialEquipmentConfirmed
     */
    public function __construct($equipmentType = null, $quantity = null, $specialEquipment = null, $specialEquipmentConfirmed = null)
    {
        $this
            ->setEquipmentType($equipmentType)
            ->setQuantity($quantity)
            ->setSpecialEquipment($specialEquipment)
            ->setSpecialEquipmentConfirmed($specialEquipmentConfirmed);
    }
    /**
     * Get equipmentType value
     * @return string|null
     */
    public function getEquipmentType()
    {
        return $this->equipmentType;
    }
    /**
     * Set equipmentType value
     * @param string $equipmentType
     * @return \Sabre\TravelItineraryRead\Structs\PricedEquipment
     */
    public function setEquipmentType($equipmentType = null)
    {
        $this->equipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \Sabre\TravelItineraryRead\Structs\PricedEquipment
     */
    public function setQuantity($quantity = null)
    {
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get specialEquipment value
     * @return string|null
     */
    public function getSpecialEquipment()
    {
        return $this->specialEquipment;
    }
    /**
     * Set specialEquipment value
     * @param string $specialEquipment
     * @return \Sabre\TravelItineraryRead\Structs\PricedEquipment
     */
    public function setSpecialEquipment($specialEquipment = null)
    {
        $this->specialEquipment = $specialEquipment;
        return $this;
    }
    /**
     * Get specialEquipmentConfirmed value
     * @return string|null
     */
    public function getSpecialEquipmentConfirmed()
    {
        return $this->specialEquipmentConfirmed;
    }
    /**
     * Set specialEquipmentConfirmed value
     * @param string $specialEquipmentConfirmed
     * @return \Sabre\TravelItineraryRead\Structs\PricedEquipment
     */
    public function setSpecialEquipmentConfirmed($specialEquipmentConfirmed = null)
    {
        $this->specialEquipmentConfirmed = $specialEquipmentConfirmed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\PricedEquipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
