<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceCache Structs
 * Meta informations extracted from the WSDL
 * - type: PriceCache
 * @subpackage Structs
 */
class PriceCache extends AbstractStructBase
{
    /**
     * The ProviderName
     * Meta informations extracted from the WSDL
     * - documentation: Pricing provider name used to identify pricing provider service
     * - minOccurs: 0
     * @var string
     */
    public $ProviderName;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Comment
     */
    public $Comment;
    /**
     * The ProviderRequest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ProviderRequest
     */
    public $ProviderRequest;
    /**
     * The ProviderResponse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ProviderResponse
     */
    public $ProviderResponse;
    /**
     * Constructor method for PriceCache
     * @uses PriceCache::setProviderName()
     * @uses PriceCache::setComment()
     * @uses PriceCache::setProviderRequest()
     * @uses PriceCache::setProviderResponse()
     * @param string $providerName
     * @param \Sabre\TravelItineraryRead\Structs\Comment $comment
     * @param \Sabre\TravelItineraryRead\Structs\ProviderRequest $providerRequest
     * @param \Sabre\TravelItineraryRead\Structs\ProviderResponse $providerResponse
     */
    public function __construct($providerName = null, \Sabre\TravelItineraryRead\Structs\Comment $comment = null, \Sabre\TravelItineraryRead\Structs\ProviderRequest $providerRequest = null, \Sabre\TravelItineraryRead\Structs\ProviderResponse $providerResponse = null)
    {
        $this
            ->setProviderName($providerName)
            ->setComment($comment)
            ->setProviderRequest($providerRequest)
            ->setProviderResponse($providerResponse);
    }
    /**
     * Get ProviderName value
     * @return string|null
     */
    public function getProviderName()
    {
        return $this->ProviderName;
    }
    /**
     * Set ProviderName value
     * @param string $providerName
     * @return \Sabre\TravelItineraryRead\Structs\PriceCache
     */
    public function setProviderName($providerName = null)
    {
        $this->ProviderName = $providerName;
        return $this;
    }
    /**
     * Get Comment value
     * @return \Sabre\TravelItineraryRead\Structs\Comment|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param \Sabre\TravelItineraryRead\Structs\Comment $comment
     * @return \Sabre\TravelItineraryRead\Structs\PriceCache
     */
    public function setComment(\Sabre\TravelItineraryRead\Structs\Comment $comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get ProviderRequest value
     * @return \Sabre\TravelItineraryRead\Structs\ProviderRequest|null
     */
    public function getProviderRequest()
    {
        return $this->ProviderRequest;
    }
    /**
     * Set ProviderRequest value
     * @param \Sabre\TravelItineraryRead\Structs\ProviderRequest $providerRequest
     * @return \Sabre\TravelItineraryRead\Structs\PriceCache
     */
    public function setProviderRequest(\Sabre\TravelItineraryRead\Structs\ProviderRequest $providerRequest = null)
    {
        $this->ProviderRequest = $providerRequest;
        return $this;
    }
    /**
     * Get ProviderResponse value
     * @return \Sabre\TravelItineraryRead\Structs\ProviderResponse|null
     */
    public function getProviderResponse()
    {
        return $this->ProviderResponse;
    }
    /**
     * Set ProviderResponse value
     * @param \Sabre\TravelItineraryRead\Structs\ProviderResponse $providerResponse
     * @return \Sabre\TravelItineraryRead\Structs\PriceCache
     */
    public function setProviderResponse(\Sabre\TravelItineraryRead\Structs\ProviderResponse $providerResponse = null)
    {
        $this->ProviderResponse = $providerResponse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\PriceCache
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
