<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: PaymentInfo is used as a container for Payment information details
 * @subpackage Structs
 */
class PaymentInfo extends AbstractStructBase
{
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Commission
     */
    public $Commission;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Payment
     */
    public $Payment;
    /**
     * Constructor method for PaymentInfo
     * @uses PaymentInfo::setCommission()
     * @uses PaymentInfo::setPayment()
     * @param \Sabre\TravelItineraryRead\Structs\Commission $commission
     * @param \Sabre\TravelItineraryRead\Structs\Payment $payment
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\Commission $commission = null, \Sabre\TravelItineraryRead\Structs\Payment $payment = null)
    {
        $this
            ->setCommission($commission)
            ->setPayment($payment);
    }
    /**
     * Get Commission value
     * @return \Sabre\TravelItineraryRead\Structs\Commission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \Sabre\TravelItineraryRead\Structs\Commission $commission
     * @return \Sabre\TravelItineraryRead\Structs\PaymentInfo
     */
    public function setCommission(\Sabre\TravelItineraryRead\Structs\Commission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get Payment value
     * @return \Sabre\TravelItineraryRead\Structs\Payment|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Sabre\TravelItineraryRead\Structs\Payment $payment
     * @return \Sabre\TravelItineraryRead\Structs\PaymentInfo
     */
    public function setPayment(\Sabre\TravelItineraryRead\Structs\Payment $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\PaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
