<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCard Structs
 * Meta informations extracted from the WSDL
 * - type: PaymentCard
 * @subpackage Structs
 */
class PaymentCard extends AbstractStructBase
{
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - documentation: CC - credit card
     * @var string
     */
    public $PaymentType;
    /**
     * The TripCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Not Used
     * @var string
     */
    public $TripCategory;
    /**
     * The CardType
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the type of magnetic striped card. Refer to OTA Code ListCard Type (CDT). | Used for codes in the OTA code tables.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9A-Z]{1,3}
     * @var string
     */
    public $CardType;
    /**
     * The CardCode
     * Meta informations extracted from the WSDL
     * - documentation: The 2 character code of the credit card issuer
     * @var string
     */
    public $CardCode;
    /**
     * The CardNumber
     * @var \Sabre\TravelItineraryRead\Structs\CardNumber
     */
    public $CardNumber;
    /**
     * The ExpiryMonth
     * @var string
     */
    public $ExpiryMonth;
    /**
     * The ExpiryYear
     * @var string
     */
    public $ExpiryYear;
    /**
     * The ExtendPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtendPayment;
    /**
     * The ApprovalList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ApprovalList
     */
    public $ApprovalList;
    /**
     * The DeferredPaymentID
     * Meta informations extracted from the WSDL
     * - documentation: Used to store Deferred Payment ID from ticketing transaction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeferredPaymentID;
    /**
     * The DefaultExtendPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DefaultExtendPayment;
    /**
     * The SuppressFromInvoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SuppressFromInvoice;
    /**
     * The GenerateApprovalAtTicketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $GenerateApprovalAtTicketing;
    /**
     * The CSCResultCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSCResultCode;
    /**
     * The CSCRemark
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSCRemark;
    /**
     * The AVSResultCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AVSResultCode;
    /**
     * The AVSRemark
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AVSRemark;
    /**
     * The BNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BNumber;
    /**
     * The CardHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardHolderName;
    /**
     * The CSC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSC;
    /**
     * The CSCValidatingCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSCValidatingCarrier;
    /**
     * The reconcileAsCash
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $reconcileAsCash;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return credit card code associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return credit card number associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * Constructor method for PaymentCard
     * @uses PaymentCard::setPaymentType()
     * @uses PaymentCard::setTripCategory()
     * @uses PaymentCard::setCardType()
     * @uses PaymentCard::setCardCode()
     * @uses PaymentCard::setCardNumber()
     * @uses PaymentCard::setExpiryMonth()
     * @uses PaymentCard::setExpiryYear()
     * @uses PaymentCard::setExtendPayment()
     * @uses PaymentCard::setApprovalList()
     * @uses PaymentCard::setDeferredPaymentID()
     * @uses PaymentCard::setDefaultExtendPayment()
     * @uses PaymentCard::setSuppressFromInvoice()
     * @uses PaymentCard::setGenerateApprovalAtTicketing()
     * @uses PaymentCard::setCSCResultCode()
     * @uses PaymentCard::setCSCRemark()
     * @uses PaymentCard::setAVSResultCode()
     * @uses PaymentCard::setAVSRemark()
     * @uses PaymentCard::setBNumber()
     * @uses PaymentCard::setCardHolderName()
     * @uses PaymentCard::setCSC()
     * @uses PaymentCard::setCSCValidatingCarrier()
     * @uses PaymentCard::setReconcileAsCash()
     * @uses PaymentCard::setCode()
     * @uses PaymentCard::setNumber()
     * @param string $paymentType
     * @param string $tripCategory
     * @param string $cardType
     * @param string $cardCode
     * @param \Sabre\TravelItineraryRead\Structs\CardNumber $cardNumber
     * @param string $expiryMonth
     * @param string $expiryYear
     * @param string $extendPayment
     * @param \Sabre\TravelItineraryRead\Structs\ApprovalList $approvalList
     * @param string $deferredPaymentID
     * @param bool $defaultExtendPayment
     * @param bool $suppressFromInvoice
     * @param bool $generateApprovalAtTicketing
     * @param string $cSCResultCode
     * @param string $cSCRemark
     * @param string $aVSResultCode
     * @param string $aVSRemark
     * @param string $bNumber
     * @param string $cardHolderName
     * @param string $cSC
     * @param string $cSCValidatingCarrier
     * @param bool $reconcileAsCash
     * @param string $code
     * @param string $number
     */
    public function __construct($paymentType = null, $tripCategory = null, $cardType = null, $cardCode = null, \Sabre\TravelItineraryRead\Structs\CardNumber $cardNumber = null, $expiryMonth = null, $expiryYear = null, $extendPayment = null, \Sabre\TravelItineraryRead\Structs\ApprovalList $approvalList = null, $deferredPaymentID = null, $defaultExtendPayment = null, $suppressFromInvoice = null, $generateApprovalAtTicketing = null, $cSCResultCode = null, $cSCRemark = null, $aVSResultCode = null, $aVSRemark = null, $bNumber = null, $cardHolderName = null, $cSC = null, $cSCValidatingCarrier = null, $reconcileAsCash = null, $code = null, $number = null)
    {
        $this
            ->setPaymentType($paymentType)
            ->setTripCategory($tripCategory)
            ->setCardType($cardType)
            ->setCardCode($cardCode)
            ->setCardNumber($cardNumber)
            ->setExpiryMonth($expiryMonth)
            ->setExpiryYear($expiryYear)
            ->setExtendPayment($extendPayment)
            ->setApprovalList($approvalList)
            ->setDeferredPaymentID($deferredPaymentID)
            ->setDefaultExtendPayment($defaultExtendPayment)
            ->setSuppressFromInvoice($suppressFromInvoice)
            ->setGenerateApprovalAtTicketing($generateApprovalAtTicketing)
            ->setCSCResultCode($cSCResultCode)
            ->setCSCRemark($cSCRemark)
            ->setAVSResultCode($aVSResultCode)
            ->setAVSRemark($aVSRemark)
            ->setBNumber($bNumber)
            ->setCardHolderName($cardHolderName)
            ->setCSC($cSC)
            ->setCSCValidatingCarrier($cSCValidatingCarrier)
            ->setReconcileAsCash($reconcileAsCash)
            ->setCode($code)
            ->setNumber($number);
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setPaymentType($paymentType = null)
    {
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get TripCategory value
     * @return string|null
     */
    public function getTripCategory()
    {
        return $this->TripCategory;
    }
    /**
     * Set TripCategory value
     * @param string $tripCategory
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setTripCategory($tripCategory = null)
    {
        $this->TripCategory = $tripCategory;
        return $this;
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setCardType($cardType = null)
    {
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setCardCode($cardCode = null)
    {
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return \Sabre\TravelItineraryRead\Structs\CardNumber|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param \Sabre\TravelItineraryRead\Structs\CardNumber $cardNumber
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setCardNumber(\Sabre\TravelItineraryRead\Structs\CardNumber $cardNumber = null)
    {
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get ExpiryMonth value
     * @return string|null
     */
    public function getExpiryMonth()
    {
        return $this->ExpiryMonth;
    }
    /**
     * Set ExpiryMonth value
     * @param string $expiryMonth
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setExpiryMonth($expiryMonth = null)
    {
        $this->ExpiryMonth = $expiryMonth;
        return $this;
    }
    /**
     * Get ExpiryYear value
     * @return string|null
     */
    public function getExpiryYear()
    {
        return $this->ExpiryYear;
    }
    /**
     * Set ExpiryYear value
     * @param string $expiryYear
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setExpiryYear($expiryYear = null)
    {
        $this->ExpiryYear = $expiryYear;
        return $this;
    }
    /**
     * Get ExtendPayment value
     * @return string|null
     */
    public function getExtendPayment()
    {
        return $this->ExtendPayment;
    }
    /**
     * Set ExtendPayment value
     * @param string $extendPayment
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setExtendPayment($extendPayment = null)
    {
        $this->ExtendPayment = $extendPayment;
        return $this;
    }
    /**
     * Get ApprovalList value
     * @return \Sabre\TravelItineraryRead\Structs\ApprovalList|null
     */
    public function getApprovalList()
    {
        return $this->ApprovalList;
    }
    /**
     * Set ApprovalList value
     * @param \Sabre\TravelItineraryRead\Structs\ApprovalList $approvalList
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setApprovalList(\Sabre\TravelItineraryRead\Structs\ApprovalList $approvalList = null)
    {
        $this->ApprovalList = $approvalList;
        return $this;
    }
    /**
     * Get DeferredPaymentID value
     * @return string|null
     */
    public function getDeferredPaymentID()
    {
        return $this->DeferredPaymentID;
    }
    /**
     * Set DeferredPaymentID value
     * @param string $deferredPaymentID
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setDeferredPaymentID($deferredPaymentID = null)
    {
        $this->DeferredPaymentID = $deferredPaymentID;
        return $this;
    }
    /**
     * Get DefaultExtendPayment value
     * @return bool|null
     */
    public function getDefaultExtendPayment()
    {
        return $this->DefaultExtendPayment;
    }
    /**
     * Set DefaultExtendPayment value
     * @param bool $defaultExtendPayment
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setDefaultExtendPayment($defaultExtendPayment = null)
    {
        $this->DefaultExtendPayment = $defaultExtendPayment;
        return $this;
    }
    /**
     * Get SuppressFromInvoice value
     * @return bool|null
     */
    public function getSuppressFromInvoice()
    {
        return $this->SuppressFromInvoice;
    }
    /**
     * Set SuppressFromInvoice value
     * @param bool $suppressFromInvoice
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setSuppressFromInvoice($suppressFromInvoice = null)
    {
        $this->SuppressFromInvoice = $suppressFromInvoice;
        return $this;
    }
    /**
     * Get GenerateApprovalAtTicketing value
     * @return bool|null
     */
    public function getGenerateApprovalAtTicketing()
    {
        return $this->GenerateApprovalAtTicketing;
    }
    /**
     * Set GenerateApprovalAtTicketing value
     * @param bool $generateApprovalAtTicketing
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setGenerateApprovalAtTicketing($generateApprovalAtTicketing = null)
    {
        $this->GenerateApprovalAtTicketing = $generateApprovalAtTicketing;
        return $this;
    }
    /**
     * Get CSCResultCode value
     * @return string|null
     */
    public function getCSCResultCode()
    {
        return $this->CSCResultCode;
    }
    /**
     * Set CSCResultCode value
     * @param string $cSCResultCode
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setCSCResultCode($cSCResultCode = null)
    {
        $this->CSCResultCode = $cSCResultCode;
        return $this;
    }
    /**
     * Get CSCRemark value
     * @return string|null
     */
    public function getCSCRemark()
    {
        return $this->CSCRemark;
    }
    /**
     * Set CSCRemark value
     * @param string $cSCRemark
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setCSCRemark($cSCRemark = null)
    {
        $this->CSCRemark = $cSCRemark;
        return $this;
    }
    /**
     * Get AVSResultCode value
     * @return string|null
     */
    public function getAVSResultCode()
    {
        return $this->AVSResultCode;
    }
    /**
     * Set AVSResultCode value
     * @param string $aVSResultCode
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setAVSResultCode($aVSResultCode = null)
    {
        $this->AVSResultCode = $aVSResultCode;
        return $this;
    }
    /**
     * Get AVSRemark value
     * @return string|null
     */
    public function getAVSRemark()
    {
        return $this->AVSRemark;
    }
    /**
     * Set AVSRemark value
     * @param string $aVSRemark
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setAVSRemark($aVSRemark = null)
    {
        $this->AVSRemark = $aVSRemark;
        return $this;
    }
    /**
     * Get BNumber value
     * @return string|null
     */
    public function getBNumber()
    {
        return $this->BNumber;
    }
    /**
     * Set BNumber value
     * @param string $bNumber
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setBNumber($bNumber = null)
    {
        $this->BNumber = $bNumber;
        return $this;
    }
    /**
     * Get CardHolderName value
     * @return string|null
     */
    public function getCardHolderName()
    {
        return $this->CardHolderName;
    }
    /**
     * Set CardHolderName value
     * @param string $cardHolderName
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setCardHolderName($cardHolderName = null)
    {
        $this->CardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get CSC value
     * @return string|null
     */
    public function getCSC()
    {
        return $this->CSC;
    }
    /**
     * Set CSC value
     * @param string $cSC
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setCSC($cSC = null)
    {
        $this->CSC = $cSC;
        return $this;
    }
    /**
     * Get CSCValidatingCarrier value
     * @return string|null
     */
    public function getCSCValidatingCarrier()
    {
        return $this->CSCValidatingCarrier;
    }
    /**
     * Set CSCValidatingCarrier value
     * @param string $cSCValidatingCarrier
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setCSCValidatingCarrier($cSCValidatingCarrier = null)
    {
        $this->CSCValidatingCarrier = $cSCValidatingCarrier;
        return $this;
    }
    /**
     * Get reconcileAsCash value
     * @return bool|null
     */
    public function getReconcileAsCash()
    {
        return $this->reconcileAsCash;
    }
    /**
     * Set reconcileAsCash value
     * @param bool $reconcileAsCash
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setReconcileAsCash($reconcileAsCash = null)
    {
        $this->reconcileAsCash = $reconcileAsCash;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
