<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerInfo Structs
 * @subpackage Structs
 */
class PassengerInfo extends AbstractStructBase
{
    /**
     * The PassengerData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PassengerData[]
     */
    public $PassengerData;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - documentation: "PassengerType" is used to return PAX type for particular fare component.
     * - use: optional
     * @var string
     */
    public $PassengerType;
    /**
     * Constructor method for PassengerInfo
     * @uses PassengerInfo::setPassengerData()
     * @uses PassengerInfo::setPassengerType()
     * @param \Sabre\TravelItineraryRead\Structs\PassengerData[] $passengerData
     * @param string $passengerType
     */
    public function __construct(array $passengerData = array(), $passengerType = null)
    {
        $this
            ->setPassengerData($passengerData)
            ->setPassengerType($passengerType);
    }
    /**
     * Get PassengerData value
     * @return \Sabre\TravelItineraryRead\Structs\PassengerData[]|null
     */
    public function getPassengerData()
    {
        return $this->PassengerData;
    }
    /**
     * Set PassengerData value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PassengerData[] $passengerData
     * @return \Sabre\TravelItineraryRead\Structs\PassengerInfo
     */
    public function setPassengerData(array $passengerData = array())
    {
        $this->PassengerData = $passengerData;
        return $this;
    }
    /**
     * Add item to PassengerData value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PassengerData $item
     * @return \Sabre\TravelItineraryRead\Structs\PassengerInfo
     */
    public function addToPassengerData(\Sabre\TravelItineraryRead\Structs\PassengerData $item)
    {
        $this->PassengerData[] = $item;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \Sabre\TravelItineraryRead\Structs\PassengerInfo
     */
    public function setPassengerType($passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\PassengerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
