<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionIds Structs
 * Meta informations extracted from the WSDL
 * - documentation: Element containing list of TripProposal option IDs related to PNR
 * @subpackage Structs
 */
class OptionIds extends AbstractStructBase
{
    /**
     * The OptionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OptionId;
    /**
     * Constructor method for OptionIds
     * @uses OptionIds::setOptionId()
     * @param string[] $optionId
     */
    public function __construct(array $optionId = array())
    {
        $this
            ->setOptionId($optionId);
    }
    /**
     * Get OptionId value
     * @return string[]|null
     */
    public function getOptionId()
    {
        return $this->OptionId;
    }
    /**
     * Set OptionId value
     * @throws \InvalidArgumentException
     * @param string[] $optionId
     * @return \Sabre\TravelItineraryRead\Structs\OptionIds
     */
    public function setOptionId(array $optionId = array())
    {
        $this->OptionId = $optionId;
        return $this;
    }
    /**
     * Add item to OptionId value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\OptionIds
     */
    public function addToOptionId($item)
    {
        $this->OptionId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\OptionIds
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
