<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Loyalty Structs
 * Meta informations extracted from the WSDL
 * - type: Loyalty
 * @subpackage Structs
 */
class Loyalty extends AbstractStructBase
{
    /**
     * The ProgramName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramName;
    /**
     * The MembershipID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MembershipID;
    /**
     * The LoyaltyLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CodeDescription
     */
    public $LoyaltyLevel;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $ExpireDate;
    /**
     * The Remark
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Remark;
    /**
     * The Metadata
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Metadata
     */
    public $Metadata;
    /**
     * The FrequentFlyer
     * Meta informations extracted from the WSDL
     * - ref: FrequentFlyer
     * @var \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public $FrequentFlyer;
    /**
     * Constructor method for Loyalty
     * @uses Loyalty::setProgramName()
     * @uses Loyalty::setMembershipID()
     * @uses Loyalty::setLoyaltyLevel()
     * @uses Loyalty::setEffectiveDate()
     * @uses Loyalty::setExpireDate()
     * @uses Loyalty::setRemark()
     * @uses Loyalty::setMetadata()
     * @uses Loyalty::setFrequentFlyer()
     * @param string $programName
     * @param string $membershipID
     * @param \Sabre\TravelItineraryRead\Structs\CodeDescription $loyaltyLevel
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string[] $remark
     * @param \Sabre\TravelItineraryRead\Structs\Metadata $metadata
     * @param \Sabre\TravelItineraryRead\Structs\FrequentFlyer $frequentFlyer
     */
    public function __construct($programName = null, $membershipID = null, \Sabre\TravelItineraryRead\Structs\CodeDescription $loyaltyLevel = null, $effectiveDate = null, $expireDate = null, array $remark = array(), \Sabre\TravelItineraryRead\Structs\Metadata $metadata = null, \Sabre\TravelItineraryRead\Structs\FrequentFlyer $frequentFlyer = null)
    {
        $this
            ->setProgramName($programName)
            ->setMembershipID($membershipID)
            ->setLoyaltyLevel($loyaltyLevel)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setRemark($remark)
            ->setMetadata($metadata)
            ->setFrequentFlyer($frequentFlyer);
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public function setProgramName($programName = null)
    {
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public function setMembershipID($membershipID = null)
    {
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get LoyaltyLevel value
     * @return \Sabre\TravelItineraryRead\Structs\CodeDescription|null
     */
    public function getLoyaltyLevel()
    {
        return $this->LoyaltyLevel;
    }
    /**
     * Set LoyaltyLevel value
     * @param \Sabre\TravelItineraryRead\Structs\CodeDescription $loyaltyLevel
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public function setLoyaltyLevel(\Sabre\TravelItineraryRead\Structs\CodeDescription $loyaltyLevel = null)
    {
        $this->LoyaltyLevel = $loyaltyLevel;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public function setExpireDate($expireDate = null)
    {
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get Remark value
     * @return string[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param string[] $remark
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public function setRemark(array $remark = array())
    {
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public function addToRemark($item)
    {
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \Sabre\TravelItineraryRead\Structs\Metadata|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \Sabre\TravelItineraryRead\Structs\Metadata $metadata
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public function setMetadata(\Sabre\TravelItineraryRead\Structs\Metadata $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get FrequentFlyer value
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer|null
     */
    public function getFrequentFlyer()
    {
        return $this->FrequentFlyer;
    }
    /**
     * Set FrequentFlyer value
     * @param \Sabre\TravelItineraryRead\Structs\FrequentFlyer $frequentFlyer
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public function setFrequentFlyer(\Sabre\TravelItineraryRead\Structs\FrequentFlyer $frequentFlyer = null)
    {
        $this->FrequentFlyer = $frequentFlyer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
