<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceOptOut Structs
 * Meta informations extracted from the WSDL
 * - type: InsuranceOptOut
 * @subpackage Structs
 */
class InsuranceOptOut extends AbstractStructBase
{
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The QuoteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuoteID;
    /**
     * The ReasonCode
     * @var string
     */
    public $ReasonCode;
    /**
     * The ReasonText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReasonText;
    /**
     * Constructor method for InsuranceOptOut
     * @uses InsuranceOptOut::setVendorCode()
     * @uses InsuranceOptOut::setQuoteID()
     * @uses InsuranceOptOut::setReasonCode()
     * @uses InsuranceOptOut::setReasonText()
     * @param string $vendorCode
     * @param string $quoteID
     * @param string $reasonCode
     * @param string $reasonText
     */
    public function __construct($vendorCode = null, $quoteID = null, $reasonCode = null, $reasonText = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setQuoteID($quoteID)
            ->setReasonCode($reasonCode)
            ->setReasonText($reasonText);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceOptOut
     */
    public function setVendorCode($vendorCode = null)
    {
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get QuoteID value
     * @return string|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param string $quoteID
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceOptOut
     */
    public function setQuoteID($quoteID = null)
    {
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceOptOut
     */
    public function setReasonCode($reasonCode = null)
    {
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get ReasonText value
     * @return string|null
     */
    public function getReasonText()
    {
        return $this->ReasonText;
    }
    /**
     * Set ReasonText value
     * @param string $reasonText
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceOptOut
     */
    public function setReasonText($reasonText = null)
    {
        $this->ReasonText = $reasonText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceOptOut
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
