<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Insurance Structs
 * @subpackage Structs
 */
class Insurance extends AbstractStructBase
{
    /**
     * The InsuranceDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\InsuranceDetails
     */
    public $InsuranceDetails;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the type of Misc segment.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: It returns information if current segment is past or not. Attribute is populated based on Insurance - InsuranceDetails - @End. In this case there is no location available, thus DFW time zone will be used.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: "Id" is used to return the id of Insurance (BasData)
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Insurance
     * @uses Insurance::setInsuranceDetails()
     * @uses Insurance::setSegmentNumber()
     * @uses Insurance::setStatus()
     * @uses Insurance::setType()
     * @uses Insurance::setIsPast()
     * @uses Insurance::setId()
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceDetails $insuranceDetails
     * @param string $segmentNumber
     * @param string $status
     * @param string $type
     * @param bool $isPast
     * @param string $id
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\InsuranceDetails $insuranceDetails = null, $segmentNumber = null, $status = null, $type = null, $isPast = null, $id = null)
    {
        $this
            ->setInsuranceDetails($insuranceDetails)
            ->setSegmentNumber($segmentNumber)
            ->setStatus($status)
            ->setType($type)
            ->setIsPast($isPast)
            ->setId($id);
    }
    /**
     * Get InsuranceDetails value
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceDetails|null
     */
    public function getInsuranceDetails()
    {
        return $this->InsuranceDetails;
    }
    /**
     * Set InsuranceDetails value
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceDetails $insuranceDetails
     * @return \Sabre\TravelItineraryRead\Structs\Insurance
     */
    public function setInsuranceDetails(\Sabre\TravelItineraryRead\Structs\InsuranceDetails $insuranceDetails = null)
    {
        $this->InsuranceDetails = $insuranceDetails;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\TravelItineraryRead\Structs\Insurance
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\TravelItineraryRead\Structs\Insurance
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Insurance
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\TravelItineraryRead\Structs\Insurance
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Insurance
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Insurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
