<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelUniqueIDType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Hold Hotel information that can be used as a reference to other systems
 * @subpackage Structs
 */
class HotelUniqueIDType extends AbstractStructBase
{
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - documentation: Application/System that is the source of this Hotel ID
     * @var string
     */
    public $Source;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Hotel ID
     * @var string
     */
    public $ID;
    /**
     * Constructor method for HotelUniqueIDType
     * @uses HotelUniqueIDType::setSource()
     * @uses HotelUniqueIDType::setID()
     * @param string $source
     * @param string $iD
     */
    public function __construct($source = null, $iD = null)
    {
        $this
            ->setSource($source)
            ->setID($iD);
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \Sabre\TravelItineraryRead\Structs\HotelUniqueIDType
     */
    public function setSource($source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Sabre\TravelItineraryRead\Structs\HotelUniqueIDType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\HotelUniqueIDType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
