<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelTotalPricing Structs
 * @subpackage Structs
 */
class HotelTotalPricing extends AbstractStructBase
{
    /**
     * The TotalTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TotalTax
     */
    public $TotalTax;
    /**
     * The TotalSurcharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TotalSurcharge
     */
    public $TotalSurcharge;
    /**
     * The ApproximateTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ApproximateTotal
     */
    public $ApproximateTotal;
    /**
     * The RateChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 8
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\RateChange[]
     */
    public $RateChange;
    /**
     * The Disclaimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Disclaimer[]
     */
    public $Disclaimer;
    /**
     * The HotelFees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\HotelFees
     */
    public $HotelFees;
    /**
     * The NightlyRateTotal
     * Meta informations extracted from the WSDL
     * - documentation: Total of all nightly rate values.
     * - minOccurs: 0
     * @var float
     */
    public $NightlyRateTotal;
    /**
     * The MaxNightlyRate
     * Meta informations extracted from the WSDL
     * - documentation: The highest nightly rate of all rates.
     * - minOccurs: 0
     * @var float
     */
    public $MaxNightlyRate;
    /**
     * The CommissionableUsdTotal
     * Meta informations extracted from the WSDL
     * - documentation: Amount used to calculate partner commissions, in USD. Total of nightly rates less surcharges.
     * - minOccurs: 0
     * @var float
     */
    public $CommissionableUsdTotal;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: The code specifying a monetary unit. Use ISO 4217, three alpha code
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for HotelTotalPricing
     * @uses HotelTotalPricing::setTotalTax()
     * @uses HotelTotalPricing::setTotalSurcharge()
     * @uses HotelTotalPricing::setApproximateTotal()
     * @uses HotelTotalPricing::setRateChange()
     * @uses HotelTotalPricing::setDisclaimer()
     * @uses HotelTotalPricing::setHotelFees()
     * @uses HotelTotalPricing::setNightlyRateTotal()
     * @uses HotelTotalPricing::setMaxNightlyRate()
     * @uses HotelTotalPricing::setCommissionableUsdTotal()
     * @uses HotelTotalPricing::setCurrencyCode()
     * @param \Sabre\TravelItineraryRead\Structs\TotalTax $totalTax
     * @param \Sabre\TravelItineraryRead\Structs\TotalSurcharge $totalSurcharge
     * @param \Sabre\TravelItineraryRead\Structs\ApproximateTotal $approximateTotal
     * @param \Sabre\TravelItineraryRead\Structs\RateChange[] $rateChange
     * @param \Sabre\TravelItineraryRead\Structs\Disclaimer[] $disclaimer
     * @param \Sabre\TravelItineraryRead\Structs\HotelFees $hotelFees
     * @param float $nightlyRateTotal
     * @param float $maxNightlyRate
     * @param float $commissionableUsdTotal
     * @param string $currencyCode
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\TotalTax $totalTax = null, \Sabre\TravelItineraryRead\Structs\TotalSurcharge $totalSurcharge = null, \Sabre\TravelItineraryRead\Structs\ApproximateTotal $approximateTotal = null, array $rateChange = array(), array $disclaimer = array(), \Sabre\TravelItineraryRead\Structs\HotelFees $hotelFees = null, $nightlyRateTotal = null, $maxNightlyRate = null, $commissionableUsdTotal = null, $currencyCode = null)
    {
        $this
            ->setTotalTax($totalTax)
            ->setTotalSurcharge($totalSurcharge)
            ->setApproximateTotal($approximateTotal)
            ->setRateChange($rateChange)
            ->setDisclaimer($disclaimer)
            ->setHotelFees($hotelFees)
            ->setNightlyRateTotal($nightlyRateTotal)
            ->setMaxNightlyRate($maxNightlyRate)
            ->setCommissionableUsdTotal($commissionableUsdTotal)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get TotalTax value
     * @return \Sabre\TravelItineraryRead\Structs\TotalTax|null
     */
    public function getTotalTax()
    {
        return $this->TotalTax;
    }
    /**
     * Set TotalTax value
     * @param \Sabre\TravelItineraryRead\Structs\TotalTax $totalTax
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setTotalTax(\Sabre\TravelItineraryRead\Structs\TotalTax $totalTax = null)
    {
        $this->TotalTax = $totalTax;
        return $this;
    }
    /**
     * Get TotalSurcharge value
     * @return \Sabre\TravelItineraryRead\Structs\TotalSurcharge|null
     */
    public function getTotalSurcharge()
    {
        return $this->TotalSurcharge;
    }
    /**
     * Set TotalSurcharge value
     * @param \Sabre\TravelItineraryRead\Structs\TotalSurcharge $totalSurcharge
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setTotalSurcharge(\Sabre\TravelItineraryRead\Structs\TotalSurcharge $totalSurcharge = null)
    {
        $this->TotalSurcharge = $totalSurcharge;
        return $this;
    }
    /**
     * Get ApproximateTotal value
     * @return \Sabre\TravelItineraryRead\Structs\ApproximateTotal|null
     */
    public function getApproximateTotal()
    {
        return $this->ApproximateTotal;
    }
    /**
     * Set ApproximateTotal value
     * @param \Sabre\TravelItineraryRead\Structs\ApproximateTotal $approximateTotal
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setApproximateTotal(\Sabre\TravelItineraryRead\Structs\ApproximateTotal $approximateTotal = null)
    {
        $this->ApproximateTotal = $approximateTotal;
        return $this;
    }
    /**
     * Get RateChange value
     * @return \Sabre\TravelItineraryRead\Structs\RateChange[]|null
     */
    public function getRateChange()
    {
        return $this->RateChange;
    }
    /**
     * Set RateChange value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\RateChange[] $rateChange
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setRateChange(array $rateChange = array())
    {
        $this->RateChange = $rateChange;
        return $this;
    }
    /**
     * Add item to RateChange value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\RateChange $item
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function addToRateChange(\Sabre\TravelItineraryRead\Structs\RateChange $item)
    {
        $this->RateChange[] = $item;
        return $this;
    }
    /**
     * Get Disclaimer value
     * @return \Sabre\TravelItineraryRead\Structs\Disclaimer[]|null
     */
    public function getDisclaimer()
    {
        return $this->Disclaimer;
    }
    /**
     * Set Disclaimer value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Disclaimer[] $disclaimer
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setDisclaimer(array $disclaimer = array())
    {
        $this->Disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Add item to Disclaimer value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Disclaimer $item
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function addToDisclaimer(\Sabre\TravelItineraryRead\Structs\Disclaimer $item)
    {
        $this->Disclaimer[] = $item;
        return $this;
    }
    /**
     * Get HotelFees value
     * @return \Sabre\TravelItineraryRead\Structs\HotelFees|null
     */
    public function getHotelFees()
    {
        return $this->HotelFees;
    }
    /**
     * Set HotelFees value
     * @param \Sabre\TravelItineraryRead\Structs\HotelFees $hotelFees
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setHotelFees(\Sabre\TravelItineraryRead\Structs\HotelFees $hotelFees = null)
    {
        $this->HotelFees = $hotelFees;
        return $this;
    }
    /**
     * Get NightlyRateTotal value
     * @return float|null
     */
    public function getNightlyRateTotal()
    {
        return $this->NightlyRateTotal;
    }
    /**
     * Set NightlyRateTotal value
     * @param float $nightlyRateTotal
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setNightlyRateTotal($nightlyRateTotal = null)
    {
        $this->NightlyRateTotal = $nightlyRateTotal;
        return $this;
    }
    /**
     * Get MaxNightlyRate value
     * @return float|null
     */
    public function getMaxNightlyRate()
    {
        return $this->MaxNightlyRate;
    }
    /**
     * Set MaxNightlyRate value
     * @param float $maxNightlyRate
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setMaxNightlyRate($maxNightlyRate = null)
    {
        $this->MaxNightlyRate = $maxNightlyRate;
        return $this;
    }
    /**
     * Get CommissionableUsdTotal value
     * @return float|null
     */
    public function getCommissionableUsdTotal()
    {
        return $this->CommissionableUsdTotal;
    }
    /**
     * Set CommissionableUsdTotal value
     * @param float $commissionableUsdTotal
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setCommissionableUsdTotal($commissionableUsdTotal = null)
    {
        $this->CommissionableUsdTotal = $commissionableUsdTotal;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\HotelTotalPricing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
