<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelFees Structs
 * Meta informations extracted from the WSDL
 * - documentation: This element breaks out certain taxes and fees collected by the hotel that are otherwise not specifically detailed in the Surcharges array. Contains size attribute to indicate the number of charges contained.
 * @subpackage Structs
 */
class HotelFees extends AbstractStructBase
{
    /**
     * The HotelFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\TravelItineraryRead\Structs\HotelFee[]
     */
    public $HotelFee;
    /**
     * Constructor method for HotelFees
     * @uses HotelFees::setHotelFee()
     * @param \Sabre\TravelItineraryRead\Structs\HotelFee[] $hotelFee
     */
    public function __construct(array $hotelFee = array())
    {
        $this
            ->setHotelFee($hotelFee);
    }
    /**
     * Get HotelFee value
     * @return \Sabre\TravelItineraryRead\Structs\HotelFee[]|null
     */
    public function getHotelFee()
    {
        return $this->HotelFee;
    }
    /**
     * Set HotelFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\HotelFee[] $hotelFee
     * @return \Sabre\TravelItineraryRead\Structs\HotelFees
     */
    public function setHotelFee(array $hotelFee = array())
    {
        $this->HotelFee = $hotelFee;
        return $this;
    }
    /**
     * Add item to HotelFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\HotelFee $item
     * @return \Sabre\TravelItineraryRead\Structs\HotelFees
     */
    public function addToHotelFee(\Sabre\TravelItineraryRead\Structs\HotelFee $item)
    {
        $this->HotelFee[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\HotelFees
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
