<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteePrepaid Structs
 * @subpackage Structs
 */
class GuaranteePrepaid extends AbstractStructBase
{
    /**
     * The CancellationRefundAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CancellationRefundAmount[]
     */
    public $CancellationRefundAmount;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: "amount" is used to return the guarantee amount.
     * - use: optional
     * @var string
     */
    public $amount;
    /**
     * The amountPercentage
     * Meta informations extracted from the WSDL
     * - documentation: "amountPercentage" is used to indicate whether the CancellationRefundAmount is an amount or a percentage.
     * - use: optional
     * @var string
     */
    public $amountPercentage;
    /**
     * The currencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "currencyCode" is used to return the guarantee currency code.
     * - use: optional
     * @var string
     */
    public $currencyCode;
    /**
     * The typeOfGuarantee
     * Meta informations extracted from the WSDL
     * - documentation: "ind" is used to return the type of guarantee, i.e. guarantee or a prepaid.
     * - use: optional
     * @var string
     */
    public $typeOfGuarantee;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the guarantee amount.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The AmountPercentage
     * Meta informations extracted from the WSDL
     * - documentation: "AmountPercentage" is used to indicate whether the CancellationRefundAmount is an amount or a percentage.
     * - use: optional
     * @var string
     */
    public $AmountPercentage;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to return the guarantee currency code.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - documentation: "Ind" is used to return the type of guarantee, i.e. guarantee or a prepaid.
     * - use: optional
     * @var string
     */
    public $Ind;
    /**
     * Constructor method for GuaranteePrepaid
     * @uses GuaranteePrepaid::setCancellationRefundAmount()
     * @uses GuaranteePrepaid::setAmount()
     * @uses GuaranteePrepaid::setAmountPercentage()
     * @uses GuaranteePrepaid::setCurrencyCode()
     * @uses GuaranteePrepaid::setTypeOfGuarantee()
     * @uses GuaranteePrepaid::setAmount_1()
     * @uses GuaranteePrepaid::setAmountPercentage_1()
     * @uses GuaranteePrepaid::setCurrencyCode_1()
     * @uses GuaranteePrepaid::setInd()
     * @param \Sabre\TravelItineraryRead\Structs\CancellationRefundAmount[] $cancellationRefundAmount
     * @param string $amount
     * @param string $amountPercentage
     * @param string $currencyCode
     * @param string $typeOfGuarantee
     * @param string $amount
     * @param string $amountPercentage
     * @param string $currencyCode
     * @param string $ind
     */
    public function __construct(array $cancellationRefundAmount = array(), $amount = null, $amountPercentage = null, $currencyCode = null, $typeOfGuarantee = null, $amount = null, $amountPercentage = null, $currencyCode = null, $ind = null)
    {
        $this
            ->setCancellationRefundAmount($cancellationRefundAmount)
            ->setAmount($amount)
            ->setAmountPercentage($amountPercentage)
            ->setCurrencyCode($currencyCode)
            ->setTypeOfGuarantee($typeOfGuarantee)
            ->setAmount_1($amount)
            ->setAmountPercentage_1($amountPercentage)
            ->setCurrencyCode_1($currencyCode)
            ->setInd($ind);
    }
    /**
     * Get CancellationRefundAmount value
     * @return \Sabre\TravelItineraryRead\Structs\CancellationRefundAmount[]|null
     */
    public function getCancellationRefundAmount()
    {
        return $this->CancellationRefundAmount;
    }
    /**
     * Set CancellationRefundAmount value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\CancellationRefundAmount[] $cancellationRefundAmount
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function setCancellationRefundAmount(array $cancellationRefundAmount = array())
    {
        $this->CancellationRefundAmount = $cancellationRefundAmount;
        return $this;
    }
    /**
     * Add item to CancellationRefundAmount value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\CancellationRefundAmount $item
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function addToCancellationRefundAmount(\Sabre\TravelItineraryRead\Structs\CancellationRefundAmount $item)
    {
        $this->CancellationRefundAmount[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get AmountPercentage value
     * @return string|null
     */
    public function getAmountPercentage()
    {
        return $this->amountPercentage;
    }
    /**
     * Set AmountPercentage value
     * @param string $amountPercentage
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function setAmountPercentage($amountPercentage = null)
    {
        $this->amountPercentage = $amountPercentage;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get typeOfGuarantee value
     * @return string|null
     */
    public function getTypeOfGuarantee()
    {
        return $this->typeOfGuarantee;
    }
    /**
     * Set typeOfGuarantee value
     * @param string $typeOfGuarantee
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function setTypeOfGuarantee($typeOfGuarantee = null)
    {
        $this->typeOfGuarantee = $typeOfGuarantee;
        return $this;
    }
    /**
     * Get amount_1 value
     * @return amount_1
     */
    public function getAmount_1()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function setAmount_1($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get amountPercentage_1 value
     * @return amountPercentage_1
     */
    public function getAmountPercentage_1()
    {
        return $this->AmountPercentage;
    }
    /**
     * Set AmountPercentage value
     * @param string $amountPercentage
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function setAmountPercentage_1($amountPercentage = null)
    {
        $this->AmountPercentage = $amountPercentage;
        return $this;
    }
    /**
     * Get currencyCode_1 value
     * @return currencyCode_1
     */
    public function getCurrencyCode_1()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function setCurrencyCode_1($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Ind value
     * @return string|null
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param string $ind
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\GuaranteePrepaid
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
