<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentFlyer Structs
 * Meta informations extracted from the WSDL
 * - type: FrequentFlyer
 * @subpackage Structs
 */
class FrequentFlyer extends AbstractStructBase
{
    /**
     * The PartnershipAirlineCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PartnershipAirlineCodes;
    /**
     * The ActionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActionCode;
    /**
     * The PreviousActionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreviousActionCode;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vendor;
    /**
     * The ReceivingCarrierCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceivingCarrierCode;
    /**
     * The VitType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $VitType;
    /**
     * The FrequentFlyerNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FrequentFlyerNumber;
    /**
     * The MembershipID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MembershipID;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductType;
    /**
     * The ProgramCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramCode;
    /**
     * The Provider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Provider;
    /**
     * The CITierLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CITierLevel;
    /**
     * The ATPCOTierLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ATPCOTierLevel;
    /**
     * The Indicators
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Indicators;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Contains information on vendor validation ex. "INVLD NAME FOR ACCT"
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Banner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Banner;
    /**
     * The Tag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tag;
    /**
     * The Tag2Char
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tag2Char;
    /**
     * Constructor method for FrequentFlyer
     * @uses FrequentFlyer::setPartnershipAirlineCodes()
     * @uses FrequentFlyer::setActionCode()
     * @uses FrequentFlyer::setPreviousActionCode()
     * @uses FrequentFlyer::setVendor()
     * @uses FrequentFlyer::setReceivingCarrierCode()
     * @uses FrequentFlyer::setVitType()
     * @uses FrequentFlyer::setFrequentFlyerNumber()
     * @uses FrequentFlyer::setMembershipID()
     * @uses FrequentFlyer::setProductType()
     * @uses FrequentFlyer::setProgramCode()
     * @uses FrequentFlyer::setProvider()
     * @uses FrequentFlyer::setCITierLevel()
     * @uses FrequentFlyer::setATPCOTierLevel()
     * @uses FrequentFlyer::setIndicators()
     * @uses FrequentFlyer::setText()
     * @uses FrequentFlyer::setBanner()
     * @uses FrequentFlyer::setTag()
     * @uses FrequentFlyer::setTag2Char()
     * @param string[] $partnershipAirlineCodes
     * @param string $actionCode
     * @param string $previousActionCode
     * @param string $vendor
     * @param string $receivingCarrierCode
     * @param int $vitType
     * @param string $frequentFlyerNumber
     * @param string $membershipID
     * @param string $productType
     * @param string $programCode
     * @param string $provider
     * @param string $cITierLevel
     * @param string $aTPCOTierLevel
     * @param string $indicators
     * @param string $text
     * @param string $banner
     * @param string $tag
     * @param string $tag2Char
     */
    public function __construct(array $partnershipAirlineCodes = array(), $actionCode = null, $previousActionCode = null, $vendor = null, $receivingCarrierCode = null, $vitType = null, $frequentFlyerNumber = null, $membershipID = null, $productType = null, $programCode = null, $provider = null, $cITierLevel = null, $aTPCOTierLevel = null, $indicators = null, $text = null, $banner = null, $tag = null, $tag2Char = null)
    {
        $this
            ->setPartnershipAirlineCodes($partnershipAirlineCodes)
            ->setActionCode($actionCode)
            ->setPreviousActionCode($previousActionCode)
            ->setVendor($vendor)
            ->setReceivingCarrierCode($receivingCarrierCode)
            ->setVitType($vitType)
            ->setFrequentFlyerNumber($frequentFlyerNumber)
            ->setMembershipID($membershipID)
            ->setProductType($productType)
            ->setProgramCode($programCode)
            ->setProvider($provider)
            ->setCITierLevel($cITierLevel)
            ->setATPCOTierLevel($aTPCOTierLevel)
            ->setIndicators($indicators)
            ->setText($text)
            ->setBanner($banner)
            ->setTag($tag)
            ->setTag2Char($tag2Char);
    }
    /**
     * Get PartnershipAirlineCodes value
     * @return string[]|null
     */
    public function getPartnershipAirlineCodes()
    {
        return $this->PartnershipAirlineCodes;
    }
    /**
     * Set PartnershipAirlineCodes value
     * @throws \InvalidArgumentException
     * @param string[] $partnershipAirlineCodes
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setPartnershipAirlineCodes(array $partnershipAirlineCodes = array())
    {
        $this->PartnershipAirlineCodes = $partnershipAirlineCodes;
        return $this;
    }
    /**
     * Add item to PartnershipAirlineCodes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function addToPartnershipAirlineCodes($item)
    {
        $this->PartnershipAirlineCodes[] = $item;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param string $actionCode
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setActionCode($actionCode = null)
    {
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get PreviousActionCode value
     * @return string|null
     */
    public function getPreviousActionCode()
    {
        return $this->PreviousActionCode;
    }
    /**
     * Set PreviousActionCode value
     * @param string $previousActionCode
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setPreviousActionCode($previousActionCode = null)
    {
        $this->PreviousActionCode = $previousActionCode;
        return $this;
    }
    /**
     * Get Vendor value
     * @return string|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param string $vendor
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setVendor($vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get ReceivingCarrierCode value
     * @return string|null
     */
    public function getReceivingCarrierCode()
    {
        return $this->ReceivingCarrierCode;
    }
    /**
     * Set ReceivingCarrierCode value
     * @param string $receivingCarrierCode
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setReceivingCarrierCode($receivingCarrierCode = null)
    {
        $this->ReceivingCarrierCode = $receivingCarrierCode;
        return $this;
    }
    /**
     * Get VitType value
     * @return int|null
     */
    public function getVitType()
    {
        return $this->VitType;
    }
    /**
     * Set VitType value
     * @param int $vitType
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setVitType($vitType = null)
    {
        $this->VitType = $vitType;
        return $this;
    }
    /**
     * Get FrequentFlyerNumber value
     * @return string|null
     */
    public function getFrequentFlyerNumber()
    {
        return $this->FrequentFlyerNumber;
    }
    /**
     * Set FrequentFlyerNumber value
     * @param string $frequentFlyerNumber
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setFrequentFlyerNumber($frequentFlyerNumber = null)
    {
        $this->FrequentFlyerNumber = $frequentFlyerNumber;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setMembershipID($membershipID = null)
    {
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setProductType($productType = null)
    {
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setProgramCode($programCode = null)
    {
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get Provider value
     * @return string|null
     */
    public function getProvider()
    {
        return $this->Provider;
    }
    /**
     * Set Provider value
     * @param string $provider
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setProvider($provider = null)
    {
        $this->Provider = $provider;
        return $this;
    }
    /**
     * Get CITierLevel value
     * @return string|null
     */
    public function getCITierLevel()
    {
        return $this->CITierLevel;
    }
    /**
     * Set CITierLevel value
     * @param string $cITierLevel
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setCITierLevel($cITierLevel = null)
    {
        $this->CITierLevel = $cITierLevel;
        return $this;
    }
    /**
     * Get ATPCOTierLevel value
     * @return string|null
     */
    public function getATPCOTierLevel()
    {
        return $this->ATPCOTierLevel;
    }
    /**
     * Set ATPCOTierLevel value
     * @param string $aTPCOTierLevel
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setATPCOTierLevel($aTPCOTierLevel = null)
    {
        $this->ATPCOTierLevel = $aTPCOTierLevel;
        return $this;
    }
    /**
     * Get Indicators value
     * @return string|null
     */
    public function getIndicators()
    {
        return $this->Indicators;
    }
    /**
     * Set Indicators value
     * @param string $indicators
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setIndicators($indicators = null)
    {
        $this->Indicators = $indicators;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Banner value
     * @return string|null
     */
    public function getBanner()
    {
        return $this->Banner;
    }
    /**
     * Set Banner value
     * @param string $banner
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setBanner($banner = null)
    {
        $this->Banner = $banner;
        return $this;
    }
    /**
     * Get Tag value
     * @return string|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * Set Tag value
     * @param string $tag
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setTag($tag = null)
    {
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Get Tag2Char value
     * @return string|null
     */
    public function getTag2Char()
    {
        return $this->Tag2Char;
    }
    /**
     * Set Tag2Char value
     * @param string $tag2Char
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public function setTag2Char($tag2Char = null)
    {
        $this->Tag2Char = $tag2Char;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\FrequentFlyer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
