<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormOfPayment Structs
 * Meta informations extracted from the WSDL
 * - type: FormOfPayment
 * @subpackage Structs
 */
class FormOfPayment extends AbstractStructBase
{
    /**
     * The CreditCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CreditCard
     */
    public $CreditCard;
    /**
     * The Cash
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cash;
    /**
     * The Check
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Check;
    /**
     * The Voucher
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Voucher;
    /**
     * The Other
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other;
    /**
     * The transactionID
     * @var string
     */
    public $transactionID;
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PaymentCard
     */
    public $PaymentCard;
    /**
     * The Invoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Invoice
     */
    public $Invoice;
    /**
     * The Docket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Docket
     */
    public $Docket;
    /**
     * The GTR
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\GTR
     */
    public $GTR;
    /**
     * The VirtualCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\VirtualCard
     */
    public $VirtualCard;
    /**
     * The PayLaterPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PayLaterPlan
     */
    public $PayLaterPlan;
    /**
     * The LoyaltyProgramRedemption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption
     */
    public $LoyaltyProgramRedemption;
    /**
     * The miscFOP
     * @var bool
     */
    public $miscFOP;
    /**
     * The migrated
     * Meta informations extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $migrated;
    /**
     * Constructor method for FormOfPayment
     * @uses FormOfPayment::setCreditCard()
     * @uses FormOfPayment::setCash()
     * @uses FormOfPayment::setCheck()
     * @uses FormOfPayment::setVoucher()
     * @uses FormOfPayment::setOther()
     * @uses FormOfPayment::setTransactionID()
     * @uses FormOfPayment::setPaymentCard()
     * @uses FormOfPayment::setInvoice()
     * @uses FormOfPayment::setDocket()
     * @uses FormOfPayment::setGTR()
     * @uses FormOfPayment::setVirtualCard()
     * @uses FormOfPayment::setPayLaterPlan()
     * @uses FormOfPayment::setLoyaltyProgramRedemption()
     * @uses FormOfPayment::setMiscFOP()
     * @uses FormOfPayment::setMigrated()
     * @param \Sabre\TravelItineraryRead\Structs\CreditCard $creditCard
     * @param string $cash
     * @param string $check
     * @param string $voucher
     * @param string $other
     * @param string $transactionID
     * @param \Sabre\TravelItineraryRead\Structs\PaymentCard $paymentCard
     * @param \Sabre\TravelItineraryRead\Structs\Invoice $invoice
     * @param \Sabre\TravelItineraryRead\Structs\Docket $docket
     * @param \Sabre\TravelItineraryRead\Structs\GTR $gTR
     * @param \Sabre\TravelItineraryRead\Structs\VirtualCard $virtualCard
     * @param \Sabre\TravelItineraryRead\Structs\PayLaterPlan $payLaterPlan
     * @param \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption $loyaltyProgramRedemption
     * @param bool $miscFOP
     * @param bool $migrated
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\CreditCard $creditCard = null, $cash = null, $check = null, $voucher = null, $other = null, $transactionID = null, \Sabre\TravelItineraryRead\Structs\PaymentCard $paymentCard = null, \Sabre\TravelItineraryRead\Structs\Invoice $invoice = null, \Sabre\TravelItineraryRead\Structs\Docket $docket = null, \Sabre\TravelItineraryRead\Structs\GTR $gTR = null, \Sabre\TravelItineraryRead\Structs\VirtualCard $virtualCard = null, \Sabre\TravelItineraryRead\Structs\PayLaterPlan $payLaterPlan = null, \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption $loyaltyProgramRedemption = null, $miscFOP = null, $migrated = false)
    {
        $this
            ->setCreditCard($creditCard)
            ->setCash($cash)
            ->setCheck($check)
            ->setVoucher($voucher)
            ->setOther($other)
            ->setTransactionID($transactionID)
            ->setPaymentCard($paymentCard)
            ->setInvoice($invoice)
            ->setDocket($docket)
            ->setGTR($gTR)
            ->setVirtualCard($virtualCard)
            ->setPayLaterPlan($payLaterPlan)
            ->setLoyaltyProgramRedemption($loyaltyProgramRedemption)
            ->setMiscFOP($miscFOP)
            ->setMigrated($migrated);
    }
    /**
     * Get CreditCard value
     * @return \Sabre\TravelItineraryRead\Structs\CreditCard|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * Set CreditCard value
     * @param \Sabre\TravelItineraryRead\Structs\CreditCard $creditCard
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setCreditCard(\Sabre\TravelItineraryRead\Structs\CreditCard $creditCard = null)
    {
        $this->CreditCard = $creditCard;
        return $this;
    }
    /**
     * Get Cash value
     * @return string|null
     */
    public function getCash()
    {
        return $this->Cash;
    }
    /**
     * Set Cash value
     * @param string $cash
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setCash($cash = null)
    {
        $this->Cash = $cash;
        return $this;
    }
    /**
     * Get Check value
     * @return string|null
     */
    public function getCheck()
    {
        return $this->Check;
    }
    /**
     * Set Check value
     * @param string $check
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setCheck($check = null)
    {
        $this->Check = $check;
        return $this;
    }
    /**
     * Get Voucher value
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param string $voucher
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setVoucher($voucher = null)
    {
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get Other value
     * @return string|null
     */
    public function getOther()
    {
        return $this->Other;
    }
    /**
     * Set Other value
     * @param string $other
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setOther($other = null)
    {
        $this->Other = $other;
        return $this;
    }
    /**
     * Get transactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->transactionID;
    }
    /**
     * Set transactionID value
     * @param string $transactionID
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setTransactionID($transactionID = null)
    {
        $this->transactionID = $transactionID;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCard|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \Sabre\TravelItineraryRead\Structs\PaymentCard $paymentCard
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setPaymentCard(\Sabre\TravelItineraryRead\Structs\PaymentCard $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Sabre\TravelItineraryRead\Structs\Invoice|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Sabre\TravelItineraryRead\Structs\Invoice $invoice
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setInvoice(\Sabre\TravelItineraryRead\Structs\Invoice $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get Docket value
     * @return \Sabre\TravelItineraryRead\Structs\Docket|null
     */
    public function getDocket()
    {
        return $this->Docket;
    }
    /**
     * Set Docket value
     * @param \Sabre\TravelItineraryRead\Structs\Docket $docket
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setDocket(\Sabre\TravelItineraryRead\Structs\Docket $docket = null)
    {
        $this->Docket = $docket;
        return $this;
    }
    /**
     * Get GTR value
     * @return \Sabre\TravelItineraryRead\Structs\GTR|null
     */
    public function getGTR()
    {
        return $this->GTR;
    }
    /**
     * Set GTR value
     * @param \Sabre\TravelItineraryRead\Structs\GTR $gTR
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setGTR(\Sabre\TravelItineraryRead\Structs\GTR $gTR = null)
    {
        $this->GTR = $gTR;
        return $this;
    }
    /**
     * Get VirtualCard value
     * @return \Sabre\TravelItineraryRead\Structs\VirtualCard|null
     */
    public function getVirtualCard()
    {
        return $this->VirtualCard;
    }
    /**
     * Set VirtualCard value
     * @param \Sabre\TravelItineraryRead\Structs\VirtualCard $virtualCard
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setVirtualCard(\Sabre\TravelItineraryRead\Structs\VirtualCard $virtualCard = null)
    {
        $this->VirtualCard = $virtualCard;
        return $this;
    }
    /**
     * Get PayLaterPlan value
     * @return \Sabre\TravelItineraryRead\Structs\PayLaterPlan|null
     */
    public function getPayLaterPlan()
    {
        return $this->PayLaterPlan;
    }
    /**
     * Set PayLaterPlan value
     * @param \Sabre\TravelItineraryRead\Structs\PayLaterPlan $payLaterPlan
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setPayLaterPlan(\Sabre\TravelItineraryRead\Structs\PayLaterPlan $payLaterPlan = null)
    {
        $this->PayLaterPlan = $payLaterPlan;
        return $this;
    }
    /**
     * Get LoyaltyProgramRedemption value
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption|null
     */
    public function getLoyaltyProgramRedemption()
    {
        return $this->LoyaltyProgramRedemption;
    }
    /**
     * Set LoyaltyProgramRedemption value
     * @param \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption $loyaltyProgramRedemption
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setLoyaltyProgramRedemption(\Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption $loyaltyProgramRedemption = null)
    {
        $this->LoyaltyProgramRedemption = $loyaltyProgramRedemption;
        return $this;
    }
    /**
     * Get miscFOP value
     * @return bool|null
     */
    public function getMiscFOP()
    {
        return $this->miscFOP;
    }
    /**
     * Set miscFOP value
     * @param bool $miscFOP
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setMiscFOP($miscFOP = null)
    {
        $this->miscFOP = $miscFOP;
        return $this;
    }
    /**
     * Get migrated value
     * @return bool|null
     */
    public function getMigrated()
    {
        return $this->migrated;
    }
    /**
     * Set migrated value
     * @param bool $migrated
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function setMigrated($migrated = false)
    {
        $this->migrated = $migrated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
