<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponent Structs
 * @subpackage Structs
 */
class FareComponent extends AbstractStructBase
{
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - documentation: "FareBasisCode" is used to return Fare Basis Code for particular Fare Component.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The BrandCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BrandCode;
    /**
     * The AccountCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountCode;
    /**
     * The PricingPassengerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PricingPassengerType;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Location
     */
    public $Location;
    /**
     * The Dates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Dates
     */
    public $Dates;
    /**
     * The FlightSegmentNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FlightSegmentNumbers
     */
    public $FlightSegmentNumbers;
    /**
     * The FareDirectionality
     * Meta informations extracted from the WSDL
     * - documentation: "FareDirectionality" is used to return directionality of the fare ("FROM" or "TO").
     * - use: optional
     * @var string
     */
    public $FareDirectionality;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return NUC amount for particular Fare Component.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The TicketDesignator
     * Meta informations extracted from the WSDL
     * - documentation: "TicketDesignator" is used to return Ticket Designator Code attached to Fare Basis Code.
     * - use: optional
     * @var string
     */
    public $TicketDesignator;
    /**
     * The GoverningCarrier
     * Meta informations extracted from the WSDL
     * - documentation: "GoverningCarrier" is used to return Governing Carrier Code e.g. EY, AA, LH.
     * - use: optional
     * @var string
     */
    public $GoverningCarrier;
    /**
     * The FareComponentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "FareComponentNumber" is used to display number of fare component stored in PQ.
     * - use: optional
     * @var string
     */
    public $FareComponentNumber;
    /**
     * Constructor method for FareComponent
     * @uses FareComponent::setFareBasisCode()
     * @uses FareComponent::setBrandCode()
     * @uses FareComponent::setAccountCode()
     * @uses FareComponent::setPricingPassengerType()
     * @uses FareComponent::setOrigin()
     * @uses FareComponent::setDestination()
     * @uses FareComponent::setLocation()
     * @uses FareComponent::setDates()
     * @uses FareComponent::setFlightSegmentNumbers()
     * @uses FareComponent::setFareDirectionality()
     * @uses FareComponent::setAmount()
     * @uses FareComponent::setTicketDesignator()
     * @uses FareComponent::setGoverningCarrier()
     * @uses FareComponent::setFareComponentNumber()
     * @param string $fareBasisCode
     * @param string $brandCode
     * @param string $accountCode
     * @param string $pricingPassengerType
     * @param string $origin
     * @param string $destination
     * @param \Sabre\TravelItineraryRead\Structs\Location $location
     * @param \Sabre\TravelItineraryRead\Structs\Dates $dates
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegmentNumbers $flightSegmentNumbers
     * @param string $fareDirectionality
     * @param string $amount
     * @param string $ticketDesignator
     * @param string $governingCarrier
     * @param string $fareComponentNumber
     */
    public function __construct($fareBasisCode = null, $brandCode = null, $accountCode = null, $pricingPassengerType = null, $origin = null, $destination = null, \Sabre\TravelItineraryRead\Structs\Location $location = null, \Sabre\TravelItineraryRead\Structs\Dates $dates = null, \Sabre\TravelItineraryRead\Structs\FlightSegmentNumbers $flightSegmentNumbers = null, $fareDirectionality = null, $amount = null, $ticketDesignator = null, $governingCarrier = null, $fareComponentNumber = null)
    {
        $this
            ->setFareBasisCode($fareBasisCode)
            ->setBrandCode($brandCode)
            ->setAccountCode($accountCode)
            ->setPricingPassengerType($pricingPassengerType)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setLocation($location)
            ->setDates($dates)
            ->setFlightSegmentNumbers($flightSegmentNumbers)
            ->setFareDirectionality($fareDirectionality)
            ->setAmount($amount)
            ->setTicketDesignator($ticketDesignator)
            ->setGoverningCarrier($governingCarrier)
            ->setFareComponentNumber($fareComponentNumber);
    }
    /**
     * Get FareBasisCode value
     * @return string
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setBrandCode($brandCode = null)
    {
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setAccountCode($accountCode = null)
    {
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get PricingPassengerType value
     * @return string|null
     */
    public function getPricingPassengerType()
    {
        return $this->PricingPassengerType;
    }
    /**
     * Set PricingPassengerType value
     * @param string $pricingPassengerType
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setPricingPassengerType($pricingPassengerType = null)
    {
        $this->PricingPassengerType = $pricingPassengerType;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setOrigin($origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setDestination($destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Location value
     * @return \Sabre\TravelItineraryRead\Structs\Location|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Sabre\TravelItineraryRead\Structs\Location $location
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setLocation(\Sabre\TravelItineraryRead\Structs\Location $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Dates value
     * @return \Sabre\TravelItineraryRead\Structs\Dates|null
     */
    public function getDates()
    {
        return $this->Dates;
    }
    /**
     * Set Dates value
     * @param \Sabre\TravelItineraryRead\Structs\Dates $dates
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setDates(\Sabre\TravelItineraryRead\Structs\Dates $dates = null)
    {
        $this->Dates = $dates;
        return $this;
    }
    /**
     * Get FlightSegmentNumbers value
     * @return \Sabre\TravelItineraryRead\Structs\FlightSegmentNumbers|null
     */
    public function getFlightSegmentNumbers()
    {
        return $this->FlightSegmentNumbers;
    }
    /**
     * Set FlightSegmentNumbers value
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegmentNumbers $flightSegmentNumbers
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setFlightSegmentNumbers(\Sabre\TravelItineraryRead\Structs\FlightSegmentNumbers $flightSegmentNumbers = null)
    {
        $this->FlightSegmentNumbers = $flightSegmentNumbers;
        return $this;
    }
    /**
     * Get FareDirectionality value
     * @return string|null
     */
    public function getFareDirectionality()
    {
        return $this->FareDirectionality;
    }
    /**
     * Set FareDirectionality value
     * @param string $fareDirectionality
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setFareDirectionality($fareDirectionality = null)
    {
        $this->FareDirectionality = $fareDirectionality;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TicketDesignator value
     * @return string|null
     */
    public function getTicketDesignator()
    {
        return $this->TicketDesignator;
    }
    /**
     * Set TicketDesignator value
     * @param string $ticketDesignator
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setTicketDesignator($ticketDesignator = null)
    {
        $this->TicketDesignator = $ticketDesignator;
        return $this;
    }
    /**
     * Get GoverningCarrier value
     * @return string|null
     */
    public function getGoverningCarrier()
    {
        return $this->GoverningCarrier;
    }
    /**
     * Set GoverningCarrier value
     * @param string $governingCarrier
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setGoverningCarrier($governingCarrier = null)
    {
        $this->GoverningCarrier = $governingCarrier;
        return $this;
    }
    /**
     * Get FareComponentNumber value
     * @return string|null
     */
    public function getFareComponentNumber()
    {
        return $this->FareComponentNumber;
    }
    /**
     * Set FareComponentNumber value
     * @param string $fareComponentNumber
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public function setFareComponentNumber($fareComponentNumber = null)
    {
        $this->FareComponentNumber = $fareComponentNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
