<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Envelope Structs
 * Meta informations extracted from the WSDL
 * - type: tns:Envelope
 * @subpackage Structs
 */
class Envelope extends AbstractStructBase
{
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Header
     * @var \Sabre\TravelItineraryRead\Structs\Header[]
     */
    public $Header;
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - ref: tns:Body
     * @var \Sabre\TravelItineraryRead\Structs\Body
     */
    public $Body;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for Envelope
     * @uses Envelope::setHeader()
     * @uses Envelope::setBody()
     * @uses Envelope::setAny()
     * @param \Sabre\TravelItineraryRead\Structs\Header[] $header
     * @param \Sabre\TravelItineraryRead\Structs\Body $body
     * @param \DOMDocument $any
     */
    public function __construct(array $header = array(), \Sabre\TravelItineraryRead\Structs\Body $body = null, \DOMDocument $any = null)
    {
        $this
            ->setHeader($header)
            ->setBody($body)
            ->setAny($any);
    }
    /**
     * Get Header value
     * @return \Sabre\TravelItineraryRead\Structs\Header[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Header[] $header
     * @return \Sabre\TravelItineraryRead\Structs\Envelope
     */
    public function setHeader(array $header = array())
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Header $item
     * @return \Sabre\TravelItineraryRead\Structs\Envelope
     */
    public function addToHeader(\Sabre\TravelItineraryRead\Structs\Header $item)
    {
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Get Body value
     * @return \Sabre\TravelItineraryRead\Structs\Body|null
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param \Sabre\TravelItineraryRead\Structs\Body $body
     * @return \Sabre\TravelItineraryRead\Structs\Envelope
     */
    public function setBody(\Sabre\TravelItineraryRead\Structs\Body $body = null)
    {
        $this->Body = $body;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\TravelItineraryRead\Structs\Envelope::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\TravelItineraryRead\Structs\Envelope
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Envelope
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
